procedure read_and_export_messages;

var 
  stop_outgoing_prv,convert_outgoing_prv : boolean;
  counter                                : integer;


label
loop, loopend;


begin  { read and write messages procedure }

crc_count      := 0;
msg_counter    := 0;
times2         := 0;

new_msg_start  := trunc(cnames_array[times1].last_message_number_exported);

write_tag_line       := cnames_array[times1].suppress_tag_use_indicator = 'N';
stop_outgoing_prv    := cnames_array[times1].stop_outgoing_private      = 'Y';
convert_outgoing_prv := cnames_array[times1].convert_outgoing_private   = 'Y';
echoes_only          := cnames_array[times1].echo_pcb_indicator         = 'Y';             
convert_to_echo      := cnames_array[times1].echo_on_export_indicator   = 'Y';



loop:
bread(msg_file,io_pointer^[1]);                         (* read header         *)
if (berr) then goto loopend;

starting_block_of_msg := btell(msg_file);


if (io_pointer^[1].time[3] <> ':') or
   (io_pointer^[1].blocks < 2) then goto loop;


if convert_to_echo then io_pointer^[1].echoflag := 'E';

if (io_pointer^[1].status <> live_message) 
                      or
  ((node_only) and (echoes_only) and (io_pointer^[1].echoflag <> 'E')) then
  begin

  bseek(msg_file,starting_block_of_msg + (io_pointer^[1].blocks -1));
  goto loop;
  end;

bread(msg_file,io_pointer^[2]);

crc_out := 0;

set_up_crc;
crcstr(io_pointer^[1].whofrom,whofrom_subject_size);
crcstr(io_pointer^[1].date,date_time_whoto_size);
crcstr(io_pointer^[2],msg_block_size);



inc(crc_count);
crc_pointer^[crc_count].crc := crc_out;
crc_pointer^[crc_count].crc_msg_number := io_pointer^[1].message_number;


if (trunc(stof(io_pointer^[1].message_number)) <= new_msg_start)  (* previous run #      *)
then goto loop;
          
if node_only then
  if stop_outgoing_prv then
    if io_pointer^[1].status_code in ['*', '+', '~', '`', '#', '$'] then goto loop;

if node_only then
  if convert_outgoing_prv then io_pointer^[1].status_code := ' ';
       
if stof(io_pointer^[1].refer_to) <> 0 then
begin
    counter := 1;
    while not (counter > crc_count) do
      begin
         if stof(io_pointer^[1].refer_to) = stof(crc_pointer^[counter].crc_msg_number) then
           begin
              move(crc_pointer^[counter].crc,io_pointer^[1].refer_to,crc_size);
              counter := crc_count;
           end;
      inc(counter);
      end; 
end;

inc(msg_counter);

if not output_file_created then
begin 
  bcreate(output_msg_filename);
  bopen(output_msg_file,output_msg_filename,100,sizeof(msg_block));              
  output_file_created := true;
end;


for counter := 3 to io_pointer^[1].blocks do    (* fill rest of message *)
begin
  bread(msg_file,io_pointer^[counter]);
end;


if write_tag_line then 
   begin
      dummy_string[0] := chr(ord(255));
      move(io_pointer^[counter - 1],dummy_string[1],255); 
      if pos('NET/Mail : ',dummy_string) < 1 then
        begin
          inc(io_pointer^[1].blocks);
          move(tag_line,io_pointer^[io_pointer^[1].blocks],sizeof(tag_line));
        end;
    end; 











for counter := 1 to (io_pointer^[1].blocks) do
   begin
      bwrite(output_msg_file,io_pointer^[counter]);                 (* of message          *)
   end;



goto loop;

loopend:

displn(itoa(msg_counter));

end;  { read and export messages procedure }

