procedure load_user_table;
label  loop,finish;
var xx : longint;

begin  { load_user_table }     

if (global_record.node_hub_indicator = 'Y') or 
   (global_record.hub_indicator = 'Y') then
begin 
exit; 
end;

displn('Loading Users into Memory...');

dummy_string := global_record.user_file_path;

if not exists(dummy_string + 'PCBNDX.A') then
begin
  dispnl(1);
  displn('Unable to find PCB User File Indexes in : ' + dummy_string);
  displn('Please insure that USER FILE PATH specified in CONFIG is correct.');
  dispnl(1);
  halt(1);
end;


dos_getmem(user_pointer,sizeof(user_array));
user_count := 0;

findfirst(dummy_string + pcbndx_prefix + '.*',anyfile,noderec);

loop:
if doserror <> 0 then goto finish;

if file_size(dummy_string + noderec.name) >= sizeof(pcbndx_record) then
begin
 bopen(work_file,dummy_string + noderec.name,50,sizeof(pcbndx_record));
 bread(work_file,pcbndx_record);
     
 while (not berr) and (user_count < maxusers) do
 begin
   crc_out := 0;
   crcstr(pcbndx_record.pcbndx_name,pcbndx_name_size);

   inc(user_count);
   user_pointer^[user_count] := crc_out;

   if user_count = maxusers then 
   begin
     bclose(work_file);
     goto finish;
   end;


   bread(work_file,pcbndx_record); 
  end;

 bclose(work_file);
end;

findnext(noderec);
goto loop;


finish:

dummy_string := global_record.work_dir + global_record.bbs_code + '.USR';
bcreate(dummy_string);
bopen(work_file,dummy_string,recbufs,sizeof(user_pointer^[1]));

for x := 1 to user_count do 
  begin 
  bwrite(work_file,user_pointer^[x]);
  end;
bclose(work_file);

dos_freemem(user_pointer);

end;  { load crc table }
