{$A+,D-,I-,L-,R-,S-,V-}
{$M 8000,0,500}

Program Export;
uses DOS,
     OpenShare,
     Dispedit,
     TPCrt,
     DosMem,
     MDosIO,
     BufIO,
     Tools,
     ErrTrap;

{procedure set_up_crc; external;}

const

title                            =  'NETMail   4.3  ';
author                           = 'Copyright (c) 1989,90  Mark J. Findlay';
compress_command                 = 'pkzip -a ';
default_global_filename          = 'GLOBAL.NET';
default_conference_filename      = 'CONF.NET';
default_national_nodelist_filename = 'NETWORK.LST';
recbufs                          = 500;
max_blocks_in_message            = 70;
max_conferences                  = 255;
maxindexes                       = 8192;
live_message                     = #225;
maxusers                         = 10000;
sysop_constant                   = 'SYSOP                    ';
pcbndx_prefix                    = 'PCBNDX';


header_foreground                = lightred;
header_background                = black;
escape_foreground                = yellow;
escape_background                = black;
main_foreground                  = white;
main_background                  = black;
confirmation_foreground          = lightred;
confirmation_background          = black;
menu_header_foreground           = lightmagenta;
menu_header_background           = black;
save_prompt_foreground           = lightred;
save_prompt_background           = black;




type
index_array          = array[1..maxindexes] of single;

user_array                 = array[1..maxusers] of word;

io_array_type        = record
    status_code                                  : char;
    message_number                               : single;
    refer_to                                     : single;
    blocks                                       : byte;
    date                                         : char8; {mm-dd-yy}
    time                                         : char5; {hh:mm}
    whoto                                        : char25;
    readdate                                     : single;
    readtime                                     : char5;
    hasreplys                                    : char;
    whofrom                                      : char25;
    subject                                      : char25;
    password                                     : char12;
    status                                       : char; {live=225}
    echoflag                                     : char; {E=Echo}
    filler                                       : char6;
end; {record}


io_array             = array[1..max_blocks_in_message] of io_array_type;



tag_line_type        = record
    init_char                                    : char;
    tag_prefix                                   : char11;
    tag                                          : array[1..60] of char;
    term_char                                    : char;
    filler                                       : array[1..55] of char;
end; {record}

old_tag              = record
    fillchar                                     : char;
    prior_tag_prefix                             : char11;
    restoffill                                   : array[1..116] of char;
end; {record}


msg_block_type       = record
    high_message_number                          : single;
    low_message_number                           : single;
    active_messages                              : single;
    callers                                      : single;
    lock_indicator                               : char6;
    filler                                       : array[1..106] of char;
end; {record}


refer_crc_type        = record
   fillx                                         : char;
   filly                                         : single;
   refno                                         : word;
end;  {record}

crc_array_type        = record
  crc                                            : word;
  crc_msg_number                                 : single;
end; {record}

crc_array             = array[1..maxindexes] of crc_array_type;


global_record_type   = record
    sysops_full_name                             : string[25];
    bbs_code                                     : string[8];
    user_file_path                               : string[25];
    work_dir                                     : string[25];
    file_dir                                     : string[25];
    comm_dir                                     : string[25];
    cnames_dir                                   : string[25];
    hub_indicator                                : char;
    verify_door_callers                          : char;
    days_old                                     : integer;
    send_indicator                               : char;
    max_bytes_in                                 : longint;
    disable_netdoor_from_hh                      : integer;
    disable_netdoor_from_mm                      : integer;
    disable_netdoor_to_hh                        : integer;
    disable_netdoor_to_mm                        : integer;
    tag_line                                     : string[60];
    node_hub_indicator                           : char;
    filler                                       : array[1..254] of char;
end; {record}


cnames_occurrence   = record
    conference_name                              : string[8];
    full_conference_filename                     : string[40];
    last_message_number_exported                 : real;
    network_indicator                            : char;
    max_messages_to_import                       : integer;
    stop_incoming_private                        : char;
    stop_outgoing_private                        : char;
    convert_incoming_private                     : char;
    convert_outgoing_private                     : char;
    echo_pcb_indicator                           : char;
    suppress_tag_use_indicator                   : char;
    echo_on_export_indicator                     : char;
    filler                                       : array[1..4] of char;
end; {record}


ws_nodeinfo_type           = record
  ws_conf                         : string[8];
  ws_num                          : real;
end; {record}

ws_nodeinfo_array        = array[1..max_conferences] of ws_nodeinfo_type;




nodeinfo_conf_type         = record
  nodeinfo_conf                   : string[8];
  nodeinfo_last_msg_processed     : single;
end; {record}

nodeinfo_record_type = record
  node_code                 : string[8];
  sysop_name                : string[25];
  tag_line                  : string[60];
  hub_ind                   : char;
  nodelist_request_ind      : char;
  registered_ind            : char;
  days_to_receive           : integer;
  send_ind                  : char;
  max_bytes_incoming        : longint;
  conferences               : array[1..max_conferences] of nodeinfo_conf_type;
end; {record}



bbs_confs_type   = record
  bbs_conf                         : string[8];
  bbs_last_message_processed       : single;
end; {record}

bbs_record_type  = record
    bb_node_code                   : string[8];
    bbs_sysop_name                 : string[25];
    bbs_tag_line                   : string[60];
    bbs_hub_ind                    : char;
    bbs_conferences                : array[1..max_conferences] of bbs_confs_type;
end; {record}

work_sysops_name_type                            = char25;

pcbndx_record_type  = record
  pcbndx_filler               : word;
  pcbndx_name                 : char25;
end; {record}


const
index_pointer:                   ^index_array = nil;   (* index pointer *)
crc_pointer:                     ^crc_array   = nil;
io_pointer:                      ^io_array    = nil;
tag_pointer:                     ^old_tag     = nil;
ws_nodeinfo_ptr:                 ^ws_nodeinfo_array = nil;
user_pointer:                    ^user_array  = nil;

var

pcbndx_name_size    : integer;
pcbndx_record       : pcbndx_record_type;
user_count          : integer;
node_only           : boolean;
savex,savey         : byte;
dummy_char          : char;
conference_found    : boolean;
term                : char;
nodelist_requested  : boolean;
override_found      : boolean;
echoes_only         : boolean;
crc_size            : byte;
noderec             : searchrec;
output_file_created           : boolean;
whofrom_subject_size : word;
msg_block_size      : word;
date_time_whoto_size      : word;
crc_count,x,y,t     : integer;
textattr_hold       : byte;
log_file            : text;
count               : integer;
work_sysops_name    : work_sysops_name_type;
msg_counter         : integer;
command             : string;          (* command string passed to DOS *)
write_tag_line      : boolean;         (* boolean tag line write ind   *)
echo_only_pcb       : boolean;         (* echo only pcboard ind msgs?  *)
tag_line            : tag_line_type;   (* tag line written             *)
times1,times2       : integer;         (* all purpose counter          *)
index_file          : dos_handle;      (* index "handle"               *)
index_filename      : dos_filename;    (* index filename handle        *)
index_size          : longint;
index_count         : longint;
nodeinfo_file       : buffered_file;
nodeinfo_record     : nodeinfo_record_type;
global_file         : buffered_file;   (* global "handle"              *)
output_msg_filename : string;          (* output message file name     *)
output_msg_file     : buffered_file;   (* output msg file handle       *)
input_msg_file      : buffered_file;   (* input  msg file handle       *)
conference_file     : buffered_file;   (* conference file "handle"     *)
work_file           : buffered_file;
bbs_file            : buffered_file;   (* bbs file "handle"            *)
conference_count    : integer;         (* number of active conferences *)
conference_locked   : boolean;         (* is msg based LOCKED?         *)
counter             : integer;
starting_block_of_msg : word;
convert_to_echo     : boolean;
refer_crc           : word;
msg_file            : buffered_file;   (* msg file "handle"            *)
dummy_real          : real;            (* all purpose real             *)
dummy_string        : string;          (* all purpose string           *)
dummy_word          : word;
seek_number         : longint;
new_msg_start       : longint;
cnames_array        : array[1..max_conferences] of cnames_occurrence;
bbs_record          : bbs_record_type;
global_record       : global_record_type;
msg_block           : msg_block_type;
return_to_main      : boolean;
logging_in_effect   : boolean;
log_file_open       : boolean;

{$i upchar.inc}
{$i setcrc.inc}
{$i makelog.inc}
{$i wait.inc}
{$i crc16.inc}
{$i loaduser.inc}
{$i cleardir.inc}
{$i header.inc}                      (* header display       procedure *)
{$i exec.inc}                        (* exec DOS command     procedure *)
{$i validate.inc}                    (* validate net files   procedure *)
{$i loadtag.inc}                     (* load tag line        procedure *)
{$i readexp.inc}                     (* read/export messages procedure *)
{$i loadglob.inc}                    (* load global file     procedure *)
{$i closindx.inc}                    (* close index file     procedure *)
{$i openmsg.inc}                     (* open message file    procedure *)
{$i saveconf.inc}                    (* save conference file procedure *)
{$i init.inc}                        (* initialization       procedure *)
{$i loadconf.inc}                    (* load conference file procedure *)
{$i saveinfo.inc}
{$i expconf.inc}                     (* export conference    procedure *)
{$i export.inc}                      (* export prep          procedure *)


Begin  {program}


initialize;                    (* display disclaimer, load config file, *)
			       (* verify command line.                  *)

export_mail;


end. {program}
