procedure export_mail;
var x,y : integer;

begin  { export }
x := 15;
y := 20;

gotoxy(x,y);


validate_files;
if return_to_main then exit;


header;
load_conference_file;
load_global_file;

if global_record.hub_indicator = 'Y' then
begin
  beep;
  displn('You are defined as a HUB system. NetDoor performs all import');
  displn('and export functions as the nodes call. If you are not operating');
  displn('as a HUB, please use the GLOBAL configuration to indicate so.');
  halt(1);
end;

clear_directory(global_record.work_dir);

load_user_table;

dos_getmem(crc_pointer,(maxindexes * sizeof(crc_out)));

load_tag_line;

dispnl(1);
disp('Exporting Conference:  ');
x := wherex;
y := wherey;

for times1 := 1 to conference_count do
begin
if (cnames_array[times1].network_indicator = 'Y') and
   (exists(cnames_array[times1].full_conference_filename)) then
  begin
    msg_counter := 0;
    gotoxy(x,wherey);
    disp(cnames_array[times1].conference_name);
    gotoxy(40,wherey);
    disp(': ');
    export_conference;
    make_log_entry;
    if (return_to_main) or (conference_locked) then exit;
  end;
end;

close_log_file;

save_nodeinfo_file;
with global_record do
  begin

dos_unlink(comm_dir + bbs_code + '.OUT');     (* delete prev export *)
dos_unlink(comm_dir + bbs_code + '.IN');     (* delete prev export *)


command := compress_command +
	     comm_dir + bbs_code + '.OUT' + ' ' + work_dir +
	     '*.*' + ' ' + file_dir + bbs_code + '.FIL' + ' ' +
	     default_national_nodelist_filename;



header;
exec_program(command);
if return_to_main then exit;              

end;

clear_directory(global_record.work_dir);

save_conference_file;


end; {export}
