procedure gather_hub_send_files;
begin

for times2 := 1 to count do          (* with each file  *)
  begin 
     for subcount := 1 to max_sends do      (* for each bbs    *)
     begin
     if send_array[times2].send_bbs[subcount][1] <> ' ' then
       begin
         with global_record do

           begin
           dummy_string := send_array[times2].send_bbs[subcount];
           delete_trailing_spaces(dummy_string);

           command := 
                      compress_command  + ' '        +      { \pkpak   }
                      file_dir                       +      { \files   }
                      dummy_string                   +
                      '.FIL' + ' '                   +      {.fil      }
                      send_array[times2].send_file;         { filename }
           end;
         exec_program(command);
       end;
     end;
  end;


end;    { gather hub send files procedure }





(* ----------------------------------------------------------------- *)


procedure send;

label loop,
      subloop,
      save_send,
      confirm_save;

begin  { send procedure }       


header;
escape_prompt;
gotoxy(menux,menuy);
textattr_hold := textattr;
textattr := menu_header_foreground + (menu_header_background * 16);
displn('                         S E N D    M E N U');
textattr := textattr_hold; 
dispnl(2);
disp('            Send maximum of ');
disp(itoa(max_sends));
displn(' files, Press F10 to "save".');
dispnl(2);
x1 := wherex;
y1 := wherey;

fillchar(send_array,sizeof(send_array),' ');


count    := 0;
  

loop:
inc(count);
if count > max_sends then goto confirm_save;

edit_chars(edit,x1,y1,'Full filename to SEND: ',send_array[count].send_file,40,term);

case term of
ESC : exit;
F1  : begin
      help;
      dec(count);
      goto loop;
      end;
F10 : begin
      if count = 1 then exit else goto save_send;
      end;
end; {case}


dummy_string := send_array[count].send_file;
if not exists(dummy_string) then
begin
dispnl(2);
disp(dummy_string);
disp(' not found...press any key...');
beep;
wait;
dec(count);
gotoxy(1,wherey);
ClrEol;
goto loop;
end;


dispnl(1);
x2 := wherex;
y2 := wherey;

subcount := 0;

subloop:
inc(subcount);
if subcount > max_sends then 
  begin
    gotoxy(x2+22,y2);
    Clreol;
    goto loop;
  end;

data_changed := false;
edit_chars(edit,x2,y2,'BBS code to SEND file: ',send_array[count].send_bbs[subcount],8,term);


case term of
ESC : exit;
F1  : begin
      help;
      dec(subcount);
      goto subloop;
      end;
end; {case}

if not data_changed then 
begin
  gotoxy(x2,y2);
  clreol;
  if subcount = 1 then dec(count);
  goto loop;
end
else
  goto subloop; 
 

confirm_save:
dispnl(3);
dummy_boolean := false;
edit_yesno(edit,wherex,wherey,'Confirm Save of SEND (Y/N): ',dummy_boolean,term);
if not dummy_boolean then exit;   

save_send:

if subcount < 2 then exit;
dec(count);

dispnl(2);
load_global_file;


disp('Gathering SEND files into ');
displn(global_record.file_dir);
dispnl(1);    

if hub then 
begin
  gather_hub_send_files;
  exit;
end;


dummy_string := global_record.file_dir + global_record.bbs_code + '.SND';

bcreate(dummy_string);
bopen(send_file,dummy_string,1,sizeof(send_array[1]));           



for times2 := 1 to count do
  begin 
     bwrite(send_file,send_array[times2]);
     dummy_string    := global_record.file_dir + remove_path(send_array[times2].send_file);
     copy_file(send_array[times2].send_file,dummy_string);
  end;

bclose(send_file);


{if hub then exit;}                               (* if hub then exit *) 


with global_record do
begin

command     := 
               compress_command          +
               ' '                       + 
               file_dir                  +
               bbs_code                  +
               '.FIL '                   +
               file_dir                  +
               '*.*';                    
end;

exec_program(command);                          (* compress *)


for times2 := 1 to count do
begin
    dummy_string := remove_path(send_array[times2].send_file);
    command := 'erase '                    +
               global_record.file_dir      +
               dummy_string;
    exec_program(command);
end;

command := 'erase '                    +
           global_record.file_dir      +
           global_record.bbs_code      +
           '.SND';
exec_program(command);


end;   { send procedure }
