procedure open_report_file;

begin    { open_report file }

report_written := false;

assign(report_file,default_report_filename);
rewrite(report_file);

write(report_file,'                            ');
writeln(report_file,title);

write(report_file,'                         ');
writeln(report_file,'  Index File Usage Report       '); 

dummy_string := system_date;
fillchar(display_char,sizeof(display_char),' ');

move(dummy_string[1],display_char,length(dummy_string));
write(report_file,'                              ');
write(report_file,display_char);
write(report_file,' at ');
dummy_string := system_time;
fillchar(display_char,sizeof(display_char),' ');
move(dummy_string[1],display_char,length(dummy_string));
writeln(report_file,display_char);

writeln(report_file);

end;   { open report file }

(* ---------------------------------------------------------------- *)

procedure write_report_record;

begin   { write report record }
fillchar(display_char,sizeof(display_char),' ');
move(cnames_array[times1].conference_name[1],display_char,length(cnames_array[times1].conference_name));
write(report_file,display_char);
write(report_file,' :  ');
write(report_file,'New msgs imported: ');
write(report_file,itoa(msg_counter));
write(report_file,'    Index is currently : ');

if index_calculated then
begin
  if (index_used > 100.0) or (index_used < 0.0) then
  write(report_file,'??????') else
  write(report_file,index_used:6:2);

  index_calculated := false;
end 
else
begin
  write(report_file,'??????');
end;

writeln(report_file,' % used.');

report_written := true;

end;

(* ---------------------------------------------------------------- *)

procedure close_report_file;

begin   { close report record }

if not report_written then
begin
write(report_file,'No Messages Imported This Run....');
end;


close(report_file);
end;
