procedure read_and_import_messages;

label continue;

type
  work_array = array[1..(max_blocks_in_message * 128)] of char;

var
first_return_code       : integer;
x_hold                  : integer;
counter                 : integer;
stop_incoming_prv       : boolean;
convert_incoming_prv    : boolean;
max_messages            : integer;
hierarchy_1             : integer;
hierarchy_2             : integer;
return_code             : integer;
return_word             : word;

const
  work_pointer  : ^work_array = nil;


label loop;


begin  { read and inport procedure }



work_pointer := @io_pointer^[2];

msg_counter := 0;

with cnames_array[times1] do
begin
stop_incoming_prv          := stop_incoming_private    = 'Y';
convert_incoming_prv       := convert_incoming_private = 'Y';
max_messages               := max_messages_to_import;
echoes_only                := echo_pcb_indicator       = 'Y';
end;


loop:

if (node_only) and (msg_counter >= max_messages) then exit;

bread(input_msg_file,io_pointer^[1]);                  (* read an input rec  *)

if berr then exit;                                     (* eof then exit      *)

starting_block_of_msg := btell(input_msg_file);

if (io_pointer^[1].time[3] <> ':') or
   (io_pointer^[1].blocks < 2) then goto loop;


if node_only then
begin

    if names_found then
       begin
	 crc_out := 0;
	 crcstr(io_pointer^[1].whofrom,pcbndx_name_size);

	 for a := 1 to names_count do
	 begin
	   if crc_out = names_array[a] then
	     begin
	       bseek(input_msg_file,starting_block_of_msg + (io_pointer^[1].blocks - 1));
	       goto loop;
	     end;
	 end;

	 crc_out := 0;
	 crcstr(io_pointer^[1].whoto,pcbndx_name_size);

	 for a := 1 to names_count do
	 begin
	   if crc_out = names_array[a] then
	     begin
	       bseek(input_msg_file,starting_block_of_msg + (io_pointer^[1].blocks - 1));
	       goto loop;
	     end;
	 end;

       end;


    if io_pointer^[1].status_code in ['*', '+', '~', '`', '#', '$'] then
    begin
      crc_out := 0;
      crcstr(io_pointer^[1].whoto,pcbndx_name_size);
      for x := 1 to user_count do
      begin
	if crc_out = user_pointer^[x] then goto continue;
      end;

    bseek(input_msg_file,starting_block_of_msg + (io_pointer^[1].blocks - 1));
    goto loop;

    end;
end;


continue:

if node_only then
  if stop_incoming_prv then
     if io_pointer^[1].status_code in ['*', '+', '~', '`', '#', '$'] then
	if io_pointer^[1].whoto <> work_sysops_name then goto loop;

if node_only then
  if convert_incoming_prv then
    if io_pointer^[1].whoto <> work_sysops_name then
       io_pointer^[1].status_code := ' ';


bread(input_msg_file,io_pointer^[2]);


crc_out := 0;

set_up_crc;
crcstr(io_pointer^[1].whofrom,whofrom_subject_size);
crcstr(io_pointer^[1].date,date_time_whoto_size);
crcstr(io_pointer^[2],msg_block_size);

refer_to_found := false;
x := 1;
move(io_pointer^[1].refer_to,refer_crc,crc_size);


while not (x > crc_count) do
begin

  if crc_out = crc_pointer^[x].crc then
  begin
    bseek(input_msg_file,starting_block_of_msg + (io_pointer^[1].blocks - 1));
    goto loop;
  end;

  if refer_crc = crc_pointer^[x].crc then     (* refer to msg found *)
    begin

       x_hold := x;
       inc(x);
						    (* but does it dupe a *)
       while not (x > crc_count) do                 (* msg further down?  *)
       begin
	 if crc_out = crc_pointer^[x].crc then
	 begin
	   bseek(input_msg_file,starting_block_of_msg + (io_pointer^[1].blocks - 1));
	   goto loop;
	 end;
       inc(x);
       end;

       x := x_hold;

    io_pointer^[1].refer_to := crc_pointer^[x].crc_msg_number;
    refer_to_found := true;
    x := crc_count;
    end;

inc(x);
end;



inc(crc_count);
crc_pointer^[crc_count].crc := crc_out;
crc_pointer^[crc_count].crc_msg_number := io_pointer^[1].message_number;



for counter := 3 to io_pointer^[1].blocks do     (* read rest of msg *)
begin
  bread(input_msg_file,io_pointer^[counter]);
end;


if tcan_present then replace_badwords;           (* edit message      *)

if tags_found then
begin
  a := 1;
  hierarchy_1 := 32000;
  hierarchy_2 := 32000;

  while (a <= tags_count) do
  begin


  return_word := search(io_pointer^[2],
	    ((io_pointer^[1].blocks - 1) * 128),
	    tags_array[a][1],length(tags_array[a]));

  if return_word <> $FFFF then
    begin
      return_code := integer(return_word);
      if return_code < hierarchy_1 then
	 begin
	   hierarchy_2 := hierarchy_1;
	   hierarchy_1 := return_code;
	 end
	 else
	 begin
	   hierarchy_2 := return_code;
	 end;
    end;
  inc(a);
  end;

  if hierarchy_2 <> 32000 then
     begin
	fillchar(work_pointer^[hierarchy_2],(128 - (hierarchy_2 mod 128)),' ');
	io_pointer^[1].blocks := (hierarchy_2 div 128) + 2;
     end;

end;

(*-----------------------------------------------------------------*)


if no_messages_in_base then
begin
  no_messages_in_base := false;
  times2 := 1;
  ftos(2.0,index_pointer^[times2]);
  dummy_real := 0.0;
end
else
begin
  ftos((abs(stof(index_pointer^[times2-1])) + dummy_int),index_pointer^[times2]);
end;


dummy_int := io_pointer^[1].blocks;                      (* set # blocks this msg *)
inc(times2);                                         (* point to next 0 entry *)
inc(msg_counter);




dummy_real := dummy_real + 1;                        (* inc message # hold *)

ftos(dummy_real,io_pointer^[1].message_number);          (* set new msg #      *)
if not refer_to_found then ftos(0.0,io_pointer^[1].refer_to); (* zero out refer to  *)

last_message_number_imported := io_pointer^[1].message_number;




for counter := 1 to io_pointer^[1].blocks do     (* write message      *)
begin
  bwrite(msg_file,io_pointer^[counter]);
end;




goto loop;

end;  { read and import messages procedure }

