procedure open_index_file;

begin  { open index file procedure }


index_filename := cnames_array[times1].full_conference_filename + '.NDX';
index_file := dos_open(index_filename,open_update);   (* open index file *)
if index_file = dos_error then
  begin
  beep;
  dispnl(1);
  disp('Error opening Index file: ');
  displn(index_filename);
  dispnl(1);
  return_to_main := true;
  halt(1);
  end;


dos_lseek(index_file,0,seek_end);
index_size := dos_tell;
if index_size > (word(maxindexes) * word(sizeof(single))) then
begin
  beep;
  dispnl(1);
  disp('Index file: ');
  disp(index_filename);
  displn(' is too large for NET-Mail to handle.');
  displn(' Use PCBoard to reduce the number of index blocks to 8 or less.');
  dispnl(1);
  return_to_main := true;
  halt(1);
  end;


dos_getmem(index_pointer,index_size);
index_count := index_size div sizeof(single);
dos_lseek(index_file,0,seek_start);

dummy_word := dos_read(index_file,index_pointer^,index_size);

end; { open index file procedure }
