procedure load_user_table;
label  loop;


begin  { load_user_table }     

if not node_only then exit;

displn('Loading Users into Memory...');

dummy_string := global_record.user_file_path;

if not exists(dummy_string + 'PCBNDX.A') then
begin
  header;
  beep;
  displn('Unable to find PCB User File Indexes in : ' + dummy_string);
  halt(1);
end;


dos_getmem(user_pointer,sizeof(user_array));
user_count := 0;

findfirst(dummy_string + pcbndx_prefix + '.*',anyfile,noderec);

loop:
if doserror <> 0 then exit;

if file_size(dummy_string + noderec.name) >= sizeof(pcbndx_record) then
begin
 bopen(pcbndx_file,dummy_string + noderec.name,50,sizeof(pcbndx_record));
 bread(pcbndx_file,pcbndx_record);
     
 while (not berr) and (user_count < maxusers) do
 begin
   crc_out := 0;
   crcstr(pcbndx_record.pcbndx_name,pcbndx_name_size);
   inc(user_count);
   user_pointer^[user_count] := crc_out;
   bread(pcbndx_file,pcbndx_record); 
  end;

 bclose(pcbndx_file);
end;

findnext(noderec);
goto loop;


end;  { load crc table }
