procedure import_mail;
var x,y : integer;

begin  { import }
x := 15;
y := 20;

gotoxy(x,y);


validate_files;
if return_to_main then exit;

header;
load_conference_file;
load_global_file;


if global_record.hub_indicator = 'Y' then
begin
  beep;
  displn('You are defined as a HUB system. NetDoor performs all import');
  displn('and export functions as the nodes call. If you are not operating');
  displn('as a HUB, please use the GLOBAL configuration to indicate so.');
  halt(1);
end;

load_names;
load_tags;

dos_getmem(crc_pointer,(maxindexes * sizeof(crc_out)));


with global_record do
begin
  dummy_string := comm_dir + bbs_code + '.IN';
  if not exists(dummy_string) then
  begin
    header;
    beep;
    disp('Error...unable to find ');
    displn(dummy_string);
    halt;
  end;
end;


with global_record do
begin
command := decompress_command +
	   comm_dir + bbs_code + '.IN' + ' ' + work_dir;
end;
exec_program(command);
if return_to_main then exit;


if exists(global_record.work_dir + default_nodelist_filename) then
move_file(global_record.work_dir + default_nodelist_filename,
	  global_record.file_dir + default_nodelist_filename);


if exists(global_record.work_dir + default_national_nodelist_filename) then
begin
  dos_unlink(default_national_nodelist_filename);
  move_file(global_record.work_dir + default_national_nodelist_filename,
	    default_national_nodelist_filename);
end;


load_tcan_file;

{open_report_file;}


header;

load_user_table;

message_direction_in_effect := (paramcount > 0) and
			       (user_count > 0) and
			       (user_count <= maxusers);


dispnl(1);
disp('Importing Conference:  ');
x := wherex;
y := wherey;

import_in_progress := true;


for times1 := 1 to conference_count do
begin

if (cnames_array[times1].network_indicator = 'Y') and
   (exists(cnames_array[times1].full_conference_filename)) then

  begin

    open_message_file;
    if conference_locked then
    begin
      dispnl(2);
      disp('Unable to Import ');
      disp(cnames_array[times1].conference_name);
      disp('...Conference LOCKED!');
      beep;
      halt;
    end;

    msg_counter := 0;
    gotoxy(x,wherey);
    disp(cnames_array[times1].conference_name);
    gotoxy(40,wherey);
    disp(': ');

    cnames_array[times1].last_message_number_exported :=
        stof(msg_block.high_message_number);

    import_conference;

    bclose(msg_file);
    displn(itoa(msg_counter));

    make_log_entry;


    if msg_counter > 0 then 
    begin
       cnames_array[times1].last_message_number_exported :=
           stof(last_message_number_imported);    
    end;

    dummy_string := global_record.work_dir + cnames_array[times1].conference_name;
    if exists(dummy_string) then dos_unlink(dummy_string);
  end;
end;

close_log_file;

with global_record do
begin
dummy_string := work_dir + bbs_code + '.FIL';
end;


if exists(dummy_string) then
begin
with global_record do
  begin
  dummy_string := file_dir;
  dummy_string[0] := chr(length(dummy_string) -1);
  command     := 
                 decompress_command        +
                 work_dir                  +
                 bbs_code                  +
                 '.FIL '                   +
                 dummy_string;
  exec_program(command);  
  end;
end;


dummy_string := global_record.file_dir + global_record.bbs_code + '.FIL';
if exists(dummy_string) then dos_unlink(dummy_string);



with global_record do
  begin
    if exists(comm_dir + bbs_code + '.IN') then
      dos_unlink(comm_dir + bbs_code + '.IN');
    if exists(comm_dir + bbs_code + '.OUT') then
      dos_unlink(comm_dir + bbs_code + '.OUT');
  end;

dummy_string := global_record.work_dir;
clear_directory(dummy_string);


save_conference_file;


end; {import}
