procedure import_conference;

begin  { import_conference procedure }


input_msg_filename := global_record.work_dir +
                      cnames_array[times1].conference_name;

if not exists(input_msg_filename) then exit;

bopen(input_msg_file,input_msg_filename,100,sizeof(msg_block));    (* open input file *)

open_index_file;                                    (* open index file *)
if return_to_main then exit;


io_pointer^[1].message_number := msg_block.high_message_number;


times2 := index_count;                              (* get 1st free index *)

while (times2 > 0) and
      (trunc(stof(index_pointer^[times2])) = 0) do  (* by reading backwards *)
begin
dec(times2);
end;

                (* times2 now points to the index of the last msg
                   In order to point to the beginning of the
                   last msg, subtract 1 from times2 because the
                   seek is relative to 0, not 1                 *)

x3 := times2;      (* save times2... *)
                                       
load_crc_table;

no_messages_in_base := (times2 < 1);

if times2 > 0 then 
begin
  bseek(msg_file,abs(trunc(stof(index_pointer^[times2]))) -1);  (* seek last message  *)
  bread(msg_file,io_pointer^[1]);                         (* get last header    *)
  dummy_real := stof(io_pointer^[1].message_number);      (* save msg number    *)
  dummy_int  := io_pointer^[1].blocks;                    (* # blks in last msg *)
end;


bseekeof(msg_file);                                 (* go to eof msg file *)
inc(times2);                                        (* point to free index *)

(* at this point, dummy_real has the last existing message number,
   the existing message file is at end, waiting to be written to,
   index_point^[times2] points to the next available index entry.
   now, just read an input message, change the message number, 
   write to the existing msg file, update the index and perform any
   exiting on the input message.                                          *)

read_and_import_messages;                           (* process input file *) 


if x3 > 0 then
begin
  index_used := (100 * (x3 + msg_counter) / index_count); 
  index_calculated := true;
end
else
begin
  index_calculated := false;
end;


if msg_counter > 0 then
begin
  update_last_msg_processed;                          (* update last msg pro  *)
  dos_lseek(index_file,0,seek_start);                 (* point to beg of ind  *)
  dos_write(index_file,index_pointer^,index_size);    (* write new index      *)
end;


close_index_file;                                   (* close index file   *)
bclose(input_msg_file);                             (* close input file   *)


end;  { import conference procedure }
