procedure reset_conference_pointer;

const
x = 8;
y = 21;

begin  { reset_conference_pointer procedure }

if not exists(cnames_ptr^[times1].full_conference_filename) then exit;

conference_locked := false;
times2 := 1;

repeat

begin

bopen(msg_file,cnames_ptr^[times1].full_conference_filename,1,sizeof(msg_block));
bread(msg_file,msg_block);
bclose(msg_file);
conference_locked := (msg_block.lock_indicator = 'LOCKED'); 
end;

if conference_locked then delay(2000);
inc(times2);

until (not conference_locked) or (times2 > 3);



if conference_locked then
  begin
    gotoxy(x,y);
    disp('Unable to reset ');
    disp(cnames_ptr^[times1].conference_name);
    disp('...conference LOCKED...');
    beep;
    disp('press any key.');
    wait;
    gotoxy(x,y);
    clreol;
  end
  else
  begin
    cnames_ptr^[times1].last_message_number_exported      := stof(msg_block.high_message_number);
  end;


end;   { reset_conference_pointer procedure }
