procedure create_nodelist_file; 

var

textnode_file : text;

(* ----------------------------------------------------------------------- *)

Begin                                           { procedure }

header;

if not exists(default_bbs_filename) then
begin
  beep; 
  displn('Unable to find ' + default_bbs_filename);
  displn('You must first enter your conference information screen');
  displn('and press F10. (Note: This is a HUB function only.)');
  disp('...Press any key...');
  wait;
  exit;
end;



displn('Creating Master Nodelist File...');




if exists(default_nodelist_filename) then dos_unlink(default_nodelist_filename);
assign(textnode_file,default_nodelist_filename);
rewrite(textnode_file);

writeln(textnode_file,'                        NetMail Participating Node List');
writeln(textnode_file,'                        -------------------------------');
writeln(textnode_file,'                                   ' + system_date);
writeln(textnode_file,' ');


     
bopen(bbs_file,default_bbs_filename,50,sizeof(bbs_record));

bread(bbs_file,bbs_record);
 
while not berr do
begin
      writeln(textnode_file,'BBSCode      : ' + bbs_record.bbs_node_code);
      writeln(textnode_file,'Sysop        : ' + bbs_record.bbs_sysop_name);
      writeln(textnode_file,'Regional HUB : ' + bbs_record.bbs_hub_ind);
      writeln(textnode_file,'Tag          : ' + bbs_record.bbs_tag_line);
      writeln(textnode_file,' ');
      writeln(textnode_file,'Conferences Carried:');
      writeln(textnode_file,' ');
    
      t := 1;
      x := 1;
      while (t <= max_conferences) and (bbs_record.bbs_conferences[t].bbs_conf <> '        ') do
      begin
         if x > 6 then 
         begin
            writeln(textnode_file,bbs_record.bbs_conferences[t].bbs_conf:10);
            x := 0;
         end
         else
         begin
            write(textnode_file,bbs_record.bbs_conferences[t].bbs_conf:10);
         end;
         inc(t);
         inc(x);
      end;
  
      for t := 1 to 2 do writeln(textnode_file,' ');
      write(textnode_file,'----------------------------------------');
      writeln(textnode_file,'-----------------------------------');
      for t := 1 to 2 do writeln(textnode_file,' ');


bread(bbs_file,bbs_record);

end;


bclose(bbs_file);
close(textnode_file);


end;    { update bbs file procedure } 


