procedure create_misc_files;

var

misc_file : text;

(* ----------------------------------------------------------------------- *)

Begin                                           { procedure }

header;

if not exists(default_global_filename) then
begin
  beep;
  displn('Unable to find ' + default_global_filename);
  displn('You must first create this file using CONFIG.EXE option 1.');
  disp('Press any key to return to main menu...');
  wait;
  exit;
end;

displn('Creating Global Information Text File...');

load_global_file;

dos_unlink(default_global_info_filename);
assign(misc_file,default_global_info_filename);
rewrite(misc_file);

writeln(misc_file,'                        NetMail Global Information File');
writeln(misc_file,'                        -------------------------------');
writeln(misc_file,'                                   ' + system_date);
writeln(misc_file,' ');

with global_record do
begin
  writeln(misc_file,'Sysop''s Name ................................. ' + sysops_full_name);
  writeln(misc_file,'BBS Code ..................................... ' + bbs_code);
  writeln(misc_file,'USER File Directory .......................... ' + user_file_path);
  writeln(misc_file,'Work Directory ............................... ' + work_dir);
  writeln(misc_file,'File Directory ............................... ' + file_dir);
  writeln(misc_file,'Comm Directory ............................... ' + comm_dir);
  writeln(misc_file,'CNAMES/CONFINFO Full Filename ................ ' + cnames_dir);
  writeln(misc_file,'Is This the HUB Configuration? ............... ' + hub_indicator);
  writeln(misc_file,'Do You Operate a Node AND Hub? ............... ' + node_hub_indicator);
  writeln(misc_file,'If Hub, Should NetDoor Verify Callers ........ ' + verify_door_callers);
  writeln(misc_file,'Accept Send Files? ........................... ' + send_indicator);
  writeln(misc_file,'Max Age (Days) of Msgs to Export/Import....... ' + itoa(days_old));
  writeln(misc_file,'Max K Bytes to Import ........................ ' + itoa(max_bytes_in));
  write(misc_file,'Disable NetDoor From ......................... ' +
        itoa(disable_netdoor_from_hh) + ':' + 
        itoa(disable_netdoor_from_mm) + ' To ' + 
        itoa(disable_netdoor_to_hh) + ':'); 
  writeln(misc_file,itoa(disable_netdoor_to_mm));
  writeln(misc_file);
  writeln(misc_file,'Tag Line: ' + tag_line);
end;    


close(misc_file);


if not exists(default_conference_filename) then
begin
  beep;
  displn('Unable to find ' + default_conference_filename);
  displn('You must first create this file using CONFIG.EXE option 2.');
  disp('Press any key to return to main menu...');
  wait;
  exit;
end;

displn('Creating Conference Information Text File...');

load_conference_file;

dos_unlink(default_conference_info_filename);
assign(misc_file,default_conference_info_filename);
rewrite(misc_file);

writeln(misc_file,'                        NetMail Conference Information File');
writeln(misc_file,'                        -----------------------------------');
writeln(misc_file,'                                     ' + system_date);
writeln(misc_file,' ');

for x := 1 to conference_count do
begin
  with cnames_ptr^[x] do
  begin
    writeln(misc_file,'Conference Name Assigned by HUB .............. ' + conference_name);
    writeln(misc_file,'Conference Filename .......................... ' + full_conference_filename);
    writeln(misc_file,'Last Msg Processed ........................... ' + ftoa(last_message_number_exported,6,0));
    writeln(misc_file,'Network Messages in This Conference .......... ' + network_indicator);
    writeln(misc_file,'Max Messages per Import ...................... ' + itoa(max_messages_to_import));
    writeln(misc_file,'Stop Incoming Private Msgs ................... ' + stop_incoming_private);
    writeln(misc_file,'Stop Outgoing Private Msgs ................... ' + stop_outgoing_private);
    writeln(misc_file,'Convert Incoming Private Msgs ................ ' + convert_incoming_private);
    writeln(misc_file,'Convert Outgoing Private Msgs ................ ' + convert_outgoing_private);
    writeln(misc_file,'Network Only "Echo=Yes" Messages ............. ' + echo_pcb_indicator);;
    writeln(misc_file,'Suppress Tag on Outgoing Messages ............ ' + suppress_tag_use_indicator);
    writeln(misc_file);
    writeln(misc_file);
  end;    
end;

close(misc_file);



end;    { create misc files procedure } 


