procedure load_confinfo_file;

begin
bopen(confinfo_file,cnames_filename,40,sizeof(confinfo_record));
bread(confinfo_file,confinfo_record);           (* priming read *)
bread(confinfo_file,confinfo_record);


times1 := 0;
conference_count := times1;

while not berr do
  begin
      inc(times1);
      conference_count := times1;

      with cnames_ptr^[times1] do 
      begin
        dummy_string                          := confinfo_record.confinfo_title;
        stoupper(dummy_string);
        conference_name                       := dummy_string;


        dummy_string := full_conference_filename;
        spaceout(dummy_string);
        full_conference_filename := dummy_string;


        full_conference_filename              := confinfo_record.confinfo_filename;
        last_message_number_exported          := 0;
        network_indicator                     := 'N';
        max_messages_to_import                := 999;
        stop_incoming_private                 := 'N';
        stop_outgoing_private                 := 'N';
        convert_incoming_private              := 'N';
        convert_outgoing_private              := 'N';
        echo_pcb_indicator                    := 'N';
        suppress_tag_use_indicator            := 'N';
      end;

  reset_conference_pointer;


  bread(confinfo_file,confinfo_record); 
  end;

bclose(confinfo_file);
end; { load confinfo file }

{--------------------------------------------------------------------}






Procedure load_cnames_file;
label finish;

begin  { load_cnames_file procedure }       

clrscr;
header;
displn('Auto-Loading and Initializing Conference Information File...');


load_global_file;
cnames_filename := global_record.cnames_dir;

if not exists(cnames_filename) then
   begin
     disp('Error...unable to find ');
     ClrEol;
     displn(cnames_filename);
     displn('Press any key to return...');
     beep; 
     wait;
     return_to_main := true;
     exit;
   end;


if remove_path(cnames_filename) = 'CONFINFO' then
begin
  load_confinfo_file;
  exit;
end;



assign(cnames_file,cnames_filename);          (* open cnames file *)
reset(cnames_file);

for times1 := 1 to 33 do                        (* bypass opening lines *)
begin   
  Readln(cnames_file,dummy_string);
end;


Readln(cnames_file,dummy_string);            (* priming read *) 
                                              (* first conf name *)



for times1 := 1 to max_conferences do
begin

  with cnames_ptr^[times1] do
      begin
        stoupper(dummy_string);
        conference_name                       := dummy_string;
        last_message_number_exported          := 0;
        network_indicator                     := 'N';
        max_messages_to_import                := 999;
        stop_incoming_private                 := 'N';
        stop_outgoing_private                 := 'N';
        convert_incoming_private              := 'N';
        convert_outgoing_private              := 'N';
        echo_pcb_indicator                    := 'N';
        suppress_tag_use_indicator            := 'N';
      end;

      for times2 := 1 to 9 do
      begin
        Readln(cnames_file,dummy_string);
      end; 


      with cnames_ptr^[times1] do
      begin
        full_conference_filename  := dummy_string;
        reset_conference_pointer;
      end;

     conference_count := times1;



      for times2 := 1 to 24 do
      begin
        Readln(cnames_file,dummy_string);
        if eof(cnames_file) then goto finish;
      end; 



end;


finish:
close(cnames_file);                               (* close cnames file    *)
end;   { load_cnames_file procedure }
