'File Types & Code to Read USERS, MSGS, PCBoard.Dat & CNames Files for QB4.5

' * * * * * PCBoard 14.x USERS File Format

TYPE User14Record                                                              ' Start
   UserName AS STRING * 25       'First name and Last name                           0
   CityState AS STRING * 24      'City and State                                    25
   Password AS STRING * 12       'Password                                          49
   BusPhone AS STRING * 13       'Business Phone Number                             61
   HomePhone AS STRING * 13      'Home Phone Number                                 74
   LastOnDate AS STRING * 6      'Last Date on system (in yymmdd format)            87
   LastOnTime AS STRING * 5      'Last Time on system (in hh:mm format)             93
   Expert AS STRING * 1          'Expert Mode - "Y" or "N"                          98
   Protocol AS STRING * 1        'Protocol                                          99
   PackedFlags AS STRING * 1     'Dirty, ClrScrn, HasMail, DontAsk, Editor         100
   LastDirScan AS STRING * 6     'Last date looked at directory (in yymmdd format) 101
   SecLevel AS STRING * 1        'Security Level CHR$(X)                           107
   TimesOn AS INTEGER            'Number of times on the system                    108
   PageLength AS STRING * 1      'Page Length CHR$(X)                              110
   Uploads AS INTEGER            'Number of Uploads                                111
   Downloads AS INTEGER          'Number of Downloads                              113
   DailyDlBytes AS STRING * 8    'Daily Download Bytes so far                      115
   UserComment AS STRING * 30    'User Maintained Comment                          123
   SysopComment AS STRING * 30   'Sysop Maintained Comment                         153
   TimeSpent AS INTEGER          'Elapsed Time on system on last date called       183
   SubDate AS STRING * 6         'Subscription Registration Date (yymmdd format)   185
   ExpSecLevel AS STRING * 1     'Subscription Expired Security Level CHR$(X)      191
   LastConference AS STRING * 1  'Last Conference left - CHR$(X) - 255 = Ext.      192
   AreaReg AS STRING * 5         'Area Registration Info (1-39) BitMap             193
   ExpAreaReg AS STRING * 5      'Expired Area Registration Info (1-39) BitMap     198
   UserScanArea AS STRING * 5    'User Message Scan Areas (1-39) BitMap            193
   TotalDownloads AS STRING * 8  'Total Bytes Download - all calls                 198
   TotalUploads AS STRING * 8    'Total Bytes Upload - all calls                   206
   Delete AS STRING * 1          'Positive Delete Flag to Delete User (Repack)     214
   LastMsgMain AS STRING * 4     'Last message read in Main Board     MKSMBF$()    215
   LastMsgConf AS STRING * 156   'Last message read in Conferences 39 * 4  "       219
   InfPointer AS LONG            'Pointer into USERS.INF record                    375
   Space2 AS STRING * 9          'Reserved                                         379
   ExtLastConference AS INTEGER  'Last Conference Left (If LastConf.$ = 255)       398
END TYPE                                                                       '   400

' * * * * * PCBoard 14.x MSGS File Header & Message Block Formats

TYPE MsgHeader14Record
   HighMsg AS STRING * 4         'High Message Number (0 - 9,999,999) MKSMBF$()
   LowMsg AS STRING * 4          'Low Message Number (0 - 9,999,999)       "
   ActiveMsg AS STRING * 4       'Number of Active Messages (0 - 32,767)   "
   LastCaller AS STRING * 4      'Number of System Callers (0 - 9,999,999) "
   Locked AS STRING * 6          'The word "LOCKED" if being updated
   Space1 AS STRING * 105        'Reserved
END TYPE

TYPE Msg14Record
   Status AS STRING * 1          'Status Flag (*+-`~ or blank)
   Number AS STRING * 4          'Message Number (0 - 9,999,999)      MKSMBF$()
   Reference AS STRING * 4       'Reference Message Number (0 - 9,999,999) "
   Blocks AS STRING * 1          'Number of 128 byte blocks in Message CHR$(X)
   MDate AS STRING * 8           'Date of Message (in mm-dd-yy format)
   MTime AS STRING * 5           'Time of Message (in hh:mm format)
   ToWho AS STRING * 25          'Who the Message is For
   MRDate AS STRING * 4          'Date of Reply Message MKSMBF$(in yymmdd format)
   MRTime AS STRING * 5          'Time of Reply Message (in hh:mm format)
   AllR AS STRING * 1            'The letter 'R' if an ALL Mesg has Reply(s)
   From AS STRING * 25           'Who the Message is From
   Subject AS STRING * 25        'Subject of the Message
   Password AS STRING * 12       'Message Password (if any or ^^)
   Deleted AS STRING * 1         'Flag for Message Status (#225 or #226)
   Echoed AS STRING * 1          'The letter 'E' if message is to be echoed
   Space1 AS STRING * 6          '(Not currently used)
END TYPE

' * * * * * PCBoard 14.x CNAMES (Not really the file format but useful for
'                                loading all the conference info into memory)

TYPE Conf14Record
      ConfName AS STRING * 16      ' Name
      AutoRejoin AS INTEGER        ' AutoConference Rejoin (0 or -1)
      ViewMembers AS INTEGER       ' Allow Viewing Conf Members
      PrivateUp AS INTEGER         ' Make Conference Uploads Private (0 or -1)
      AllMailPrivate AS INTEGER    ' Make All Messages Private
      EchoMail AS INTEGER          ' ECHO Mail in Conference
      AddSec AS INTEGER            ' Additional Conference Security
      AddTime AS INTEGER           ' Additional Conference Time
      MsgBlocks AS INTEGER         ' Number of Message Blocks
      MsgFile AS STRING * 64       ' Loc/Name of Main Board Message File
      BRDMFile AS STRING * 64      ' Loc/Name of Users Menu
      BRDSFile AS STRING * 64      ' Loc/Name of Sysops Menu
      NEWSFile AS STRING * 64      ' Loc/Name of NEWS File
      PubSortMthd AS INTEGER       ' Public Upload Sort Method
      PubUploadDir AS STRING * 64  ' Loc/Name Public Upload Dir File
      PubUploadPath AS STRING * 64 ' Location of Public Uploads
      PriSortMthd AS INTEGER       ' Private Upload Sort Method
      PriUploadDir AS STRING * 64  ' Loc/Name Private Upload Dir File
      PriUploadPath AS STRING * 64 ' Location of Private Uploads
      DoorFile AS STRING * 64
      DoorLstFile AS STRING * 64
      BltFile AS STRING * 64
      BltLstFile AS STRING * 64
      ScriptFile AS STRING * 64
      ScriptLstFile AS STRING * 64
      DirFile AS STRING * 64
      DirLstFile AS STRING * 64
      DLPathFile AS STRING * 64
END TYPE

TYPE PCBNDXRECORD
   Index AS INTEGER
   UserName As STRING * 25
END TYPE


' * * * * * PCBoard 14.5 PCBOARD.SYS File Formats

TYPE PCBSYSRECORD
    Display AS STRING * 2   'Display On/Off ("-1" = On, " 0" = Off)
    Printer AS STRING * 2   'Printer On/Off ("-1" = On, " 0" = Off)
    PageBell AS STRING * 2  'Page Bell On/Off ("-1" = On, " 0" = Off)
    CallAlarm AS STRING * 2 'Caller Alarm On/Off ("-1" = On, " 0" = Off)
    SysopFlag AS STRING * 1 'Sysop Flag (" ", "N"=sysop next, "X"=exit dos)
    ErrCorr AS STRING * 2   'Error Corrected ("-1" = On, " 0" = Off)
    Graphics AS STRING * 1  'Graphics Mode ('Y'=yes, 'N'=no, '7'=7E1)
    NodeChat AS STRING * 1  'Node Chat Status ('A'=available, 'U'=unavailable)
    DTEPort  AS STRING * 5  'DTE Port Speed (PC to Modem speed)
    Connect  AS STRING * 5  'Connect Speed shown to caller or "Local"
    RecNum   AS INTEGER     'User's Record Number in the USERS file
    FirstName AS STRING * 15 'User's First Name (padded to 15 characters)
    Password AS STRING * 12 'User's Password (padded to 12 characters)
    TimeOn   AS INTEGER     'Time User Logged On (in minutes since midnight)
    TimeUsed AS INTEGER     'Time used so far today (negative number of minutes)
    TimeOnF  AS STRING * 5  'Time User Logged On (in "HH:MM" format)
    DayTime  AS INTEGER     'Time Allowed On (from PWRD file) (see note 1 below)
    DLKbytes AS INTEGER     'Allowed K-Bytes for Download (see note 2 below)
    ConfArea AS STRING * 1  'Conference Area user was in (if <= 255)
    ConfJoined AS STRING * 5 'Conference Areas the user has joined this session
    ConfScaned AS STRING * 5 'Conference Areas the user has scanned this session
    ConfAddTime AS INTEGER  'Conference Add Time in minutes
    CreditTIme AS INTEGER   'Upload/Sysop CHAT Credit Minutes (see note 3 below)
    LangExt AS STRING * 4   'Language Extension (see note 4 below)
    UserName AS STRING * 25 'User's Full Name (padded to 25 characters)
    MinRemain AS INTEGER    'Calculated Minutes Remaining (see note 5 below)
    NodeNum AS STRING * 1   'Node Number (or ' ' if no network)
    EventTime AS STRING * 5 'Scheduled Event Time (in "HH:MM" format)
    EventOn AS STRING * 2   'Is Event Active ("-1" = On, " 0" = Off)
    EventSlide AS STRING * 2 'Slide Event ("-1" = On, " 0" = Off)
    MemMesg AS SINGLE       'Memorized Message Number
    ComPort AS STRING * 1   'Comm Port Number (0=none, 1-8)
    Reserved1 AS STRING * 1 'Reserved for PCBoard
    Reserved2 AS STRING * 1 'Reserved for PCBoard
    ANSI AS STRING * 1      'Use ANSI (1 = Yes, 0 = No)
    EventDate AS STRING * 8 'Last Event Date (in "MM-DD-YY" format)
    EventMin AS INTEGER     'Last Event Minute (in minutes since midnight)
    ExitToDOS AS STRING * 1 'Caller Exited to DOS (1 = Yes, 0 = No)
    EventDue AS STRING * 1  'Event Up Coming (1 = Yes, 0 = No)
    StopUploads AS STRING * 1 'Stop Uploads (1 = Yes, 0 = No)
    ConfAreaIn AS INTEGER  ' Conference Area user was in (up to 65535)
END TYPE
'  varies  bitmap  varies  High Conference Areas the user has joined (note 6)
'  varies  bitmap  varies  High Conference Areas the user has scanned (note 6)
