Convert Basic reals to normal LongInts  (wonder if you need them for the
same reason I wrote these routines <grin>).  Anyway, heres my method of
doing it:

Unit BasicReal;

Interface
  Function Bas2Lng(InValue: LongInt): LongInt;
                {Convert Basic Short Reals to LongInts}

  Function Lng2Bas(InValue: LongInt): LongInt;
                {Convert LongInts to Basic Short Reals}

Implementation

Function Bas2Lng(InValue: LongInt): LongInt;

  Var
  Temp: LongInt;
  Negative: Boolean;
  Expon: Integer;

  Begin
    If InValue And $00800000 <> 0 Then
      Negative := True
    Else
      Negative := False;
    Expon := InValue shr 24;
    Expon := Expon and $ff;
    Temp := InValue and $007FFFFF;
    Temp := Temp or $00800000;
    Expon := Expon - 152;
    If Expon < 0 Then Temp := Temp shr Abs(Expon)
      Else Temp := Temp shl Expon;
    If Negative Then
      Bas2Lng := -Temp
    Else
      Bas2Lng := Temp;
    If Expon = 0 Then
      Bas2Lng := 0;
  End;


Function Lng2Bas(InValue: LongInt): LongInt;
  Var
  Negative: Boolean;
  Expon: LongInt;

  Begin
  If InValue = 0 Then
    Lng2Bas := 0
  Else
    Begin
    If InValue < 0 Then
      Begin
      Negative := True;
      InValue := Abs(InValue);
      End
    Else
      Negative := False;
    Expon := 152;
    If InValue < $007FFFFF Then
      While ((InValue and $00800000) = 0) Do
        Begin
        InValue := InValue shl 1;
        Dec(Expon);
        End
    Else
      While ((InValue And $FF000000) <> 0) Do
        Begin
        InValue := InValue shr 1;
        Inc(Expon);
        End;
    InValue := InValue And $007FFFFF;
    If Negative Then
      InValue := InValue Or $00800000;
    Lng2Bas := InValue + (Expon shl 24);
    End;
  End;

Begin
End.

Hope these help.  BTW you should soon receive my application for P-Net.
Later
Mark May
