/*   tvcmdex.c
 *   TVFS (Toronto Virtual File System) FSD (File System Driver) command library utility.
 *
 *   (c) Copyright International Business Machines Corporation 1994.
 *   All rights reserved.
 *
 *   01/22/93   M.D. Leitch   Creation.
 */

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "tvcmd.h"

#define       TVCMD_HOTKEY1    't'
#define       TVCMD_HOTKEY2    'T'
#define       TVCMD_MOUNT      "TVMOUNT"
#define       TVCMD_UNMOUNT    "TVUMOUNT"
#define       TVCMD_LINK       "TVLINK"
#define       TVCMD_UNLINK     "TVULINK"
#define       TVCMD_MKDIR      "TVMKDIR"

#define       TVCMD_MSG001     "TVCMD: Usage is \"TVCMD {tvmount-cmd|tvumount-cmd|tvlink-cmd|tvulink-cmd|tvmkdir-cmd}*\"\n"

#define       TVCMD_OK          0
#define       TVCMD_FAILURE     16

#define       TVCMD_checkRc(RC) if ((RC) != TVCMD_OK) return(RC)
#define       TVCMD_failure()   {printf(TVCMD_MSG001);return(TVCMD_FAILURE);}

#define       TVCMD_cast_int(INT) ((short)  (INT))
#define       TVCMD_cast_ptr(PTR) ((PPCHAR) (PTR))

int              main(
int                   argc,
char                 *argv[],
char                 *envp[])
{
   int                ixArgc;        /* The argument index. */
   int                myArgc;        /* The current argc value. */
   PPCHAR             myArgv;        /* The current argv value. */
   short              rc=0;

   TVCMD_FUNCTION     oldFunction;   /* The function to invoke (previous). */
   TVCMD_FUNCTION     newFunction;   /* The function to invoke (current). */
   unsigned int       tvcmdCount=0;  /* The count of functions invoked. */

   /* Validate the passed parameters. */
   if (argc <= 1)
      TVCMD_failure();

   /* Iterate over the set of commands. */
   ixArgc = 0;
   while (ixArgc < argc)
   {
      /* Parse the current command. */
      myArgc = 1;
      newFunction = NULL;
      while(1)      
      {
         /* Determine if we are done. */
         ixArgc++;
         if (ixArgc >= argc)
            break;         
         
         /* Determine if we have a new command. */
         if ((*argv[ixArgc] == TVCMD_HOTKEY1) ||
             (*argv[ixArgc] == TVCMD_HOTKEY2))
         {
                 if (stricmp(argv[ixArgc], TVCMD_MOUNT)   == 0)
               newFunction = TvMount;
            else if (stricmp(argv[ixArgc], TVCMD_UNMOUNT) == 0)
               newFunction = TvUmount;
            else if (stricmp(argv[ixArgc], TVCMD_LINK)    == 0)
               newFunction = TvLink;
            else if (stricmp(argv[ixArgc], TVCMD_UNLINK)  == 0)
               newFunction = TvUlink;
            else if (stricmp(argv[ixArgc], TVCMD_MKDIR)  == 0)
               newFunction = TvMkdir;
         }

#ifdef   __32BIT__
         /* Thunk each element of argv. */
         myArgv = TVCMD_cast_ptr(&argv[ixArgc]);
        *myArgv =                 argv[ixArgc];
#endif

         /* Process the existing command. */
         if (! newFunction)
         {
            myArgc++;
            continue;
         }

         /* Process the new command. */
         tvcmdCount++;
         if (tvcmdCount > 1)
            break;
         if (ixArgc != 1)
            TVCMD_failure();
         oldFunction = newFunction;
         newFunction = NULL;
      }

      /* Ensure we even have a command. */
      if (! tvcmdCount)
         TVCMD_failure();

      /* Run the current command. */
      myArgv = TVCMD_cast_ptr(&argv[ixArgc - myArgc]);
      rc = (*oldFunction)(TVCMD_cast_int(myArgc),
                                         myArgv,
                          TVCMD_cast_ptr(envp));
      TVCMD_checkRc(rc);

      /* Process the next command. */
      oldFunction = newFunction;
   }

   return(TVCMD_OK);
}
