/*   tvcmd.h    TVFS command interface exported definitions.
 *
 *   (c) International Business Machines Corporation 1994.
 *   All rights reserved.
 *
 *   Dependencies: none.
 *
 *   01/18/93   M.D. Leitch   Creation.
 */

/*************** P U B L I C   D E C L A R A T I O N S ****************/

#ifdef __32BIT__
  #define TVENTRY _Far16 _Pascal
  #define PPCHAR  char *_Seg16 *_Seg16
#else
  #define TVENTRY EXPENTRY
  #define PPCHAR  char **
#endif

typedef short    (TVENTRY TVCMD_fn)(short argc, PPCHAR argv, PPCHAR envp);
typedef TVCMD_fn *TVCMD_FUNCTION;                            /* The exported function type. */

short TVENTRY   TvMount (short argc, PPCHAR argv, PPCHAR envp); /* Mount a TVFS drive. */
short TVENTRY   TvUmount(short argc, PPCHAR argv, PPCHAR envp); /* Unmount a TVFS drive. */
                                                                      
short TVENTRY   TvLink  (short argc, PPCHAR argv, PPCHAR envp); /* Link to a TVFS drive. */
short TVENTRY   TvUlink (short argc, PPCHAR argv, PPCHAR envp); /* Unlink from a TVFS drive. */
                                                                      
short TVENTRY   TvMkdir (short argc, PPCHAR argv, PPCHAR envp); /* Make a directory anywhere. */

