/*   tvremote.h    TVFS remote file system interface exported definitions.
 *
 *   (c) Copyright Internation Business Machines Corporation 1994.
 *   All rights reserved.
 *
 *   Dependencies: <os2.h>
 *
 *   11/04/91   M.D. Leitch   Creation.
 *   12/09/91   M.D. Leitch   Added UID, PID, and PDB fields.
 *   07/09/92   M.D. Leitch   Port to 32 bit (conditional).
 *   09/01/92   M.D. Leitch   Full 32 bit port.
 *   10/31/92   M.D. Leitch   Redefine PID type.
 *   11/01/93   D.N. McDonald Alter to wait for response, select when to
 *                            notify, and select drives for notify
 *                            (a.k.a. Blocking on open and close).
 *   01/19/93   M.D. Leitch   Integrated DNM changes.
 */

/**********************************************************************/
/*************** P U B L I C   D E C L A R A T I O N S ****************/
/**********************************************************************/

/* Miscellaneous 16/32 bit declarations...............................*/

#ifdef           __32BIT__
#define          TVREMOTE_PARM_TYPE               _Seg16
#define          TVREMOTE_HFILE                   USHORT
#define          TVREMOTE_ENTRY                   APIRET16 APIENTRY16 /* USHORT _Pascal _Far16 */
#define          TVREMOTE_GetSeg                  Dos16GetSeg
#define          TVREMOTE_FreeSeg                 Dos16FreeSeg
                 TVREMOTE_ENTRY                   Dos16GetSeg(SEL sel);
                 TVREMOTE_ENTRY                   Dos16FreeSeg(SEL sel);
#else
#define          TVREMOTE_PARM_TYPE
#define          TVREMOTE_HFILE                   HFILE
#define          TVREMOTE_ENTRY                   USHORT pascal far
#define          TVREMOTE_GetSeg                  DosGetSeg
#define          TVREMOTE_FreeSeg                 DosFreeSeg
#endif

/* TVFS parameter types...............................................*/

#define          TVREMOTE_OPEN_PARM               TVREMOTE_OPEN  TVREMOTE_PARM_TYPE
#define          TVREMOTE_CLOSE_PARM              TVREMOTE_CLOSE TVREMOTE_PARM_TYPE

#define          TVREMOTE_OpenTvfsName(PARM)      (((PSZ) PARM) + (PARM->TvfsNameOffset))
#define          TVREMOTE_OpenFileName(PARM)      (((PSZ) PARM) + (PARM->FileNameOffset))
#define          TVREMOTE_OpenFileHandle(PARM)    (PARM->FileHandle)
#define          TVREMOTE_OpenActionTaken(PARM)   (PARM->ActionTaken)
#define          TVREMOTE_OpenFileSize(PARM)      (PARM->FileSize)
#define          TVREMOTE_OpenFileAttribute(PARM) (PARM->FileAttribute)
#define          TVREMOTE_OpenFlag(PARM)          (PARM->OpenFlag)
#define          TVREMOTE_OpenMode(PARM)          (PARM->OpenMode)
#define          TVREMOTE_OpenRc(PARM)            (PARM->OpenRc)
#define          TVREMOTE_OpenUid(PARM)           (PARM->Uid)
#define          TVREMOTE_OpenPid(PARM)           (PARM->Pid)
#define          TVREMOTE_OpenPdb(PARM)           (PARM->Pdb)
#define          TVREMOTE_OpenBlocked(PARM)       (PARM->Blocked)

#define          TVREMOTE_CloseTvfsName(PARM)     (((PSZ) PARM) + (PARM->TvfsNameOffset))
#define          TVREMOTE_CloseFileName(PARM)     (((PSZ) PARM) + (PARM->FileNameOffset))
#define          TVREMOTE_CloseFileHandle(PARM)   (PARM->FileHandle)
#define          TVREMOTE_CloseRc(PARM)           (PARM->CloseRc)
#define          TVREMOTE_CloseUid(PARM)          (PARM->Uid)
#define          TVREMOTE_ClosePid(PARM)          (PARM->Pid)
#define          TVREMOTE_ClosePdb(PARM)          (PARM->Pdb)
#define          TVREMOTE_CloseBlocked(PARM)      (PARM->Blocked)

/* TVFS message utilities.............................................*/

#define          TVREMOTE_MSG_POSTOPEN            (WM_USER + 1)
#define          TVREMOTE_MSG_POSTCLOSE           (WM_USER + 2)
#define          TVREMOTE_MSG_PREOPEN             (WM_USER + 3)
#define          TVREMOTE_MSG_PRECLOSE            (WM_USER + 4)
#define          TVREMOTE_MSG_USER                (WM_USER +10)
#define          TVREMOTE_MSG_OPEN                TVREMOTE_MSG_POSTOPEN
#define          TVREMOTE_MSG_CLOSE               TVREMOTE_MSG_POSTCLOSE

#define          TVREMOTE_MsgParmGet(MP1,MP2)     ((TVREMOTE_GetSeg((SEL) MP1) == NO_ERROR) ? \
                                                   (MAKEP((SEL) MP1, 0)) : (NULL))
#define          TVREMOTE_MsgParmUnblock(PARM)    ((PARM->Blocked) ? TVREMOTE_Unblock() : NO_ERROR)
#define          TVREMOTE_MsgParmFree(PARM)       (TVREMOTE_FreeSeg(SELECTOROF(PARM)))
#define          TVREMOTE_MsgParmSize(MP1,MP2)    ((ULONG) MP2)

/* TVFS message queue add/delete/list utilities.......................*/

typedef USHORT   TVREMOTE_OPTION_MASK;
typedef ULONG    TVREMOTE_DRIVE_MASK;
typedef USHORT   TVREMOTE_TIMER_INTERVAL;

#define          TVREMOTE_NOTIFY_PREOPEN          0x0001 
#define          TVREMOTE_NOTIFY_POSTOPEN         0x0010 
#define          TVREMOTE_NOTIFY_PRECLOSE         0x0100 
#define          TVREMOTE_NOTIFY_POSTCLOSE        0x1000 
#define          TVREMOTE_NOTIFY_DEFAULT         (TVREMOTE_NOTIFY_POSTOPEN | TVREMOTE_NOTIFY_POSTCLOSE)

#define          TVREMOTE_BLOCK_PREOPEN           0x0001 
#define          TVREMOTE_BLOCK_POSTOPEN          0x0010 
#define          TVREMOTE_BLOCK_PRECLOSE          0x0100
#define          TVREMOTE_BLOCK_POSTCLOSE         0x1000
#define          TVREMOTE_BLOCK_DEFAULT           0x0000                      

#define          TVREMOTE_TIMEOUT_DEFAULT         15 /* seconds, 0 => infinity. */

#define          TVREMOTE_DriveMaskSet(LETTER)    (TVREMOTE_DriveMaskTable[toupper(LETTER) - ('A')])
#define          TVREMOTE_DRIVE_DEFAULT           0xFFFFFFFF

TVREMOTE_ENTRY          TVREMOTE_ADD(HMQ QueueName,     /* Add a new TVFS remote entry (basic/default version). */
                                     PSZ Description);
TVREMOTE_ENTRY   TVREMOTE_ADD_CUSTOM(HMQ QueueName,     /* Add a new TVFS remote entry (full featured version). */
                                     PSZ Description,
                                     TVREMOTE_OPTION_MASK    EventNotifyMask,
                                     TVREMOTE_OPTION_MASK    EventBlockMask,
                                     TVREMOTE_TIMER_INTERVAL EventBlockTimeout,
                                     TVREMOTE_DRIVE_MASK     TvfsDriveMask,
                                     TVREMOTE_DRIVE_MASK     RedirectedDriveMask);
TVREMOTE_ENTRY      TVREMOTE_UNBLOCK(void);             /* Release the IFS if it is blocked. */
TVREMOTE_ENTRY       TVREMOTE_DELETE(HMQ     QueueName);/* Delete an existing TVFS remote entry. */
TVREMOTE_ENTRY         TVREMOTE_LIST(PBYTE   ResultArea,/* List the current TVFS remote entries. */
                                     PUSHORT ResultAreaSize);

#define          TVREMOTE_AddDefault TVREMOTE_ADD
#define          TVREMOTE_AddCustom  TVREMOTE_ADD_CUSTOM
#define          TVREMOTE_Unblock    TVREMOTE_UNBLOCK
#define          TVREMOTE_Delete     TVREMOTE_DELETE
#define          TVREMOTE_List       TVREMOTE_LIST

/**********************************************************************/
/************** P R I V A T E   D E C L A R A T I O N S ***************/
/**********************************************************************/

typedef USHORT   TVREMOTE_BOOLEAN;

typedef struct   {
USHORT           TvfsNameOffset;                  /* The TVFS name for the file being opened. */
USHORT           FileNameOffset;                  /* The real name for the file being opened. */
TVREMOTE_HFILE   FileHandle;                      /* DosOpen parameter (output). */
USHORT           ActionTaken;                     /* DosOpen parameter (output). */
ULONG            FileSize;                        /* DosOpen parameter (input).  */
USHORT           FileAttribute;                   /* DosOpen parameter (input).  */
USHORT           OpenFlag;                        /* DosOpen parameter (input).  */
USHORT           OpenMode;                        /* DosOpen parameter (input).  */
USHORT           OpenRc;                          /* DosOpen return code.        */
USHORT           Uid;                             /* The user ID of the initial opener. */
PID              Pid;                             /* The process ID of the initial opener. */
USHORT           Pdb;                             /* The program data block of the initial opener (DOS). */
TVREMOTE_BOOLEAN Blocked;                         /* Is the TVFS blocked, waiting for us to process the event? */
}               *TVREMOTE_OPEN, aTVREMOTE_OPEN;   /* The TVREMOTE DosOpen control block. */

typedef struct   {
USHORT           TvfsNameOffset;                  /* The TVFS name for the file being closed. */
USHORT           FileNameOffset;                  /* The real name for the file being closed. */
TVREMOTE_HFILE   FileHandle;                      /* DosClose parameter (input).  */
USHORT           CloseRc;                         /* DosClose return code.        */
USHORT           Uid;                             /* The user ID of the initial opener. */
PID              Pid;                             /* The process ID of the initial opener. */
USHORT           Pdb;                             /* The program data block of the initial opener (DOS). */
TVREMOTE_BOOLEAN Blocked;                         /* Is the TVFS blocked, waiting for us to process the event? */
}               *TVREMOTE_CLOSE, aTVREMOTE_CLOSE; /* The TVREMOTE DosClose control block. */
      

#ifdef              TVREMOTE_DRIVE_MASK_TABLE     /* Define to use TVFS_DriveMaskSet. */
TVREMOTE_DRIVE_MASK TVREMOTE_DriveMaskTable[] = {0x00000001, /* APOLOGY: */
                                                 0x00000002, /* This */
                                                 0x00000004, /* is */
                                                 0x00000008, /* an */
                                                 0x00000010, /* ugly */
                                                 0x00000020, /* way */
                                                 0x00000040, /* to */
                                                 0x00000080, /* do */
                                                 0x00000100, /* this */
                                                 0x00000200, /* but */
                                                 0x00000400, /* without */
                                                 0x00000800, /* a */
                                                 0x00001000, /* 32 */
                                                 0x00002000, /* bit */
                                                 0x00004000, /* shift */
                                                 0x00008000, /* operator */
                                                 0x00010000, /* in */
                                                 0x00020000, /* 16 */
                                                 0x00040000, /* bit */
                                                 0x00080000, /* land */
                                                 0x00100000, /* I */
                                                 0x00200000, /* do */
                                                 0x00400000, /* not */
                                                 0x00800000, /* see */
                                                 0x01000000, /* a */
                                                 0x02000000, /* better */
                                                 0x04000000, /* way */
                                                 0x08000000, /* ! */
                                                 0x10000000,
                                                 0x20000000,
                                                 0x40000000,
                                                 0x80000000};
#endif
