/***************************************************************************
PM Patrol API C/C++ header

API: DCFGetStats (Data Collection Facility - retrieve stats)
-----------------------------------------------------------------------------
     Prototype:  APIRC APIENTRY DCFGetStats (PDCFSTATS pDCFStats)
     Parms:      PPDCFSTATS         ... Address to DCFSTATS structure
     Returns:    DCF_NO_ERROR       ... Succesfull with no errors
                 DCF_PARM_ERROR     ... Invalid parm specified
                 DCF_INACTIVE_ERROR ... DCF not active

     Notes:      Statistics are updated at frequencies defined in the PM Patrol
                 "Refresh Settings" dialog under "Settings" options.
                 Refer to PM Patrol on-line help for details and examples.

API: DCFVerify   (Data Collection Facility - verify DCF active state)
-----------------------------------------------------------------------------
     Prototype:  BOOL APIENTRY DCFVerify (void)
     Parms:      None
     Returns:    TRUE               ... DCF active
                 FALSE              ... DCF not active

API: DCFUserDefined (Data Collection Facility - User defined monitor)
-----------------------------------------------------------------------------
     Prototype:  APIRC APIENTRY DCFUserDefined (PCHAR buffer)
     Parms:      None
     Returns:    DCF_NO_ERROR       ... Succesfull with no errors
                 DCF_PARM_ERROR     ... Invalid parm specified
                 DCF_INACTIVE_ERROR ... DCF not active

API: PMPShutDown (Shutdown PM Patrol and DCF)
-----------------------------------------------------------------------------
     Prototype:  BOOL APIENTRY PMPShutDown (void)
     Parms:      None
     Returns:    TRUE               ... Succesfull with no errors
                 FALSE              ... PM Patrol not active
****************************************************************************/

/* double inclusion */
#ifndef INCL_PMPAPI
#define INCL_PMPAPI

/* define additional types */
#if !defined(OS2_INCLUDED) && !defined(INCL_NEWTYPES1)
#define INCL_NEWTYPES1
typedef short            SHORT;
typedef SHORT *          PSHORT;
typedef unsigned short   USHORT;
typedef USHORT *         PUSHORT;
typedef long             LONG;
typedef LONG *           PLONG;
typedef unsigned long    ULONG;
typedef ULONG *          PULONG;
typedef char             CHAR;
typedef CHAR *           PCHAR;
typedef unsigned char    UCHAR;
typedef UCHAR *          PUCHAR;
typedef UCHAR            BYTE;
typedef BYTE *           PBYTE;
typedef int              INT;
typedef INT *            PINT;
typedef void             VOID;
typedef VOID *           PVOID;
typedef ULONG            BOOL;
typedef BOOL *           PBOOL;
#endif

#ifndef INCL_NEWTYPES2
#define INCL_NEWTYPES2
typedef double           DOUBLE;
typedef DOUBLE *         PDOUBLE;
typedef INT              FD;

#ifdef UNIX
typedef INT              APIRC;
typedef APIRC *          PAPIRC;
typedef pid_t            PID;
typedef unsigned int     TID;
#ifndef APIENTRY
#define APIENTRY
#endif
#else
typedef ULONG            APIRC;
typedef APIRC *          PAPIRC;
typedef USHORT           APIRC16;
typedef APIRC16 *        PAPIRC16;
typedef USHORT           HFILE16;
typedef HFILE16 *        PHFILE16;
#ifndef APIENTRY
#define APIENTRY         _System
#endif
#endif
#endif

/* define DCF specifics */
#define DCF_NETWID_SIZE                     15
#define DCF_NETUID_SIZE                     15
#define DCF_NETDID_SIZE                     15
#define DCF_NETSID_SIZE                     15
#define DCF_DRVONL_SIZE                     26
#define DCF_GRAPH_SIZE                      11
#define DCF_EXENAME_SIZE                    8
#define DCF_PSTATS_SIZE                     64
#define DCF_USER_SIZE                       20
#define DCF_VERSION_SIZE                    12

#define DCF_NO_ERROR                        0
#define DCF_PARM_ERROR                      1
#define DCF_INACTIVE_ERROR                  2

/* structure definitions */
#pragma pack(1)
typedef struct dcfpstats
{
  ULONG         pid;                             /* process id               */
  ULONG         ppid;                            /* parent process id        */
  ULONG         sid;                             /* session id               */
  ULONG         type;                            /* process type PROG_*      */
  BOOL          mmt32Bit;                        /* 16 or 32-bit indicator   */
  USHORT        modHandle;                       /* module handle            */
  USHORT        tidCount;                        /* thread count             */
  USHORT        semCount;                        /* sem count                */
  USHORT        modCount;                        /* mod count                */
  USHORT        shrCount;                        /* sharemem count           */
  USHORT        maxClass;                        /* max thread pri class     */
  LONG          startTime;                       /* start time (time_t)      */
  USHORT        cpuPct;                          /* cpu percent              */
  USHORT        runCnt;                          /* internal to PMP          */
  CHAR          exeName[DCF_EXENAME_SIZE+1];     /* executable name (8.3)    */
} DCFPSTATS, *PDCFPSTATS;

typedef struct dcfstats
{
  CHAR          pmpVersion[DCF_VERSION_SIZE+1];  /* PMP version              */
  LONG          pmpStartTime;                    /* PMP start time (time_t)  */
  BOOL          hpfs32ActInd;                    /* hpfs 386 active indicator*/
  BOOL          mmActInd;                        /* mmos2 active indicator   */
  BOOL          netActInd;                       /* net active indicator     */
  BOOL          netLogonInd;                     /* net logged-on indicator  */
  BOOL          lpt1ActInd;                      /* LPT1 monitor indicator   */
  BOOL          lpt2ActInd;                      /* LPT2 monitor indicator   */
  BOOL          lpt3ActInd;                      /* LPT3 monitor indicator   */
  BOOL          spoolActInd;                     /* Spooler active indicator */
  LONG          upDateTime;                      /* DCF up-date time (time_t)*/

  ULONG         upTimeSecs;                      /* system up-time seconds   */
  ULONG         iconTimeSecs;                    /* internet connect seconds */
  CHAR          netWSId    [DCF_NETWID_SIZE+1];  /* net workstation id       */
  CHAR          netUserId  [DCF_NETUID_SIZE+1];  /* net logon id             */
  CHAR          netDomainId[DCF_NETDID_SIZE+1];  /* net logon domain         */
  CHAR          netServerId[DCF_NETSID_SIZE+1];  /* net logon server         */
  DOUBLE        netIn;                           /* net req in bytes         */
  DOUBLE        netOut;                          /* net req out bytes        */
  DOUBLE        lpt1TotIO;                       /* lpt1 I/O total bytes     */
  DOUBLE        lpt1TotTime;                     /* lpt1 total ms            */
  ULONG         lpt1TotJobs;                     /* lpt1 total jobs          */
  DOUBLE        lpt2TotIO;                       /* lpt2 I/O total bytes     */
  DOUBLE        lpt2TotTime;                     /* lpt2 total ms            */
  ULONG         lpt2TotJobs;                     /* lpt2 total jobs          */
  DOUBLE        lpt3TotIO;                       /* lpt3 I/O total bytes     */
  DOUBLE        lpt3TotTime;                     /* lpt3 total ms            */
  ULONG         lpt3TotJobs;                     /* lpt3 total jobs          */
  CHAR          drivesOnLine[DCF_DRVONL_SIZE+1]; /* drive map array          */
  CHAR          drive1;                          /* drive letter             */
  BOOL          drive1OffLine;                   /* drive off line indicator */
  DOUBLE        drive1Size;                      /* drive size bytes         */
  DOUBLE        drive1Free;                      /* drive free bytes         */
  CHAR          drive2;                          /* drive letter             */
  BOOL          drive2OffLine;                   /* drive off line indicator */
  DOUBLE        drive2Size;                      /* drive size bytes         */
  DOUBLE        drive2Free;                      /* drive free bytes         */
  CHAR          drive3;                          /* drive letter             */
  BOOL          drive3OffLine;                   /* drive off line indicator */
  DOUBLE        drive3Size;                      /* drive size bytes         */
  DOUBLE        drive3Free;                      /* drive free bytes         */
  CHAR          drive4;                          /* drive letter             */
  BOOL          drive4OffLine;                   /* drive off line indicator */
  DOUBLE        drive4Size;                      /* drive size bytes         */
  DOUBLE        drive4Free;                      /* drive free bytes         */
  CHAR          drive5;                          /* drive letter             */
  BOOL          drive5OffLine;                   /* drive off line indicator */
  DOUBLE        drive5Size;                      /* drive size bytes         */
  DOUBLE        drive5Free;                      /* drive free bytes         */
  CHAR          drive6;                          /* drive letter             */
  BOOL          drive6OffLine;                   /* drive off line indicator */
  DOUBLE        drive6Size;                      /* drive size bytes         */
  DOUBLE        drive6Free;                      /* drive free bytes         */
  SHORT         batFreePct;                      /* battery life percent     */
  ULONG         swpAllocReserved;                /* swap file bytes reserved */
  ULONG         swpAllocInit;                    /* swap file bytes at boot  */
  ULONG         swpAlloc;                        /* swap file bytes current  */
  ULONG         swpFree;                         /* swap free bytes          */
  USHORT        swpFreePct;                      /* swap free percent        */
  CHAR          swpFreeGph[DCF_GRAPH_SIZE+1];    /* swap free graph          */
  ULONG         ramPhys;                         /* physical memory bytes    */
  DOUBLE        totVirt;                         /* virtual total bytes      */
  ULONG         ramVirt;                         /* virtual avail bytes      */
  USHORT        ramVirtPct;                      /* virtual avail percent    */
  CHAR          ramVirtGph[DCF_GRAPH_SIZE+1];    /* virtual avail graph      */
  ULONG         ramRes;                          /* resident memory bytes    */
  USHORT        ramResPct;                       /* resident memory percent  */
  CHAR          ramResGph[DCF_GRAPH_SIZE+1];     /* resident memory graph    */
  ULONG         ramSwap;                         /* swappable memory bytes   */
  USHORT        ramSwapPct;                      /* swappable memory percent */
  CHAR          ramSwapGph[DCF_GRAPH_SIZE+1];    /* swappable memory graph   */
  ULONG         ramFree;                         /* free memory bytes        */
  USHORT        ramFreePct;                      /* free memory percent      */
  CHAR          ramFreeGph[DCF_GRAPH_SIZE+1];    /* free memory graph        */
  ULONG         ramUsed;                         /* used memory bytes        */
  USHORT        ramUsedPct;                      /* used memory percent      */
  CHAR          ramUsedGph[DCF_GRAPH_SIZE+1];    /* used memory graph        */
  USHORT        hpfsRCachePct;                   /* hpfs386 cache read pct   */
  CHAR          hpfsRCacheGph[DCF_GRAPH_SIZE+1]; /* hpfs386 cache read graph */
  USHORT        hpfsWCachePct;                   /* hpfs386 cache write pct  */
  CHAR          hpfsWCacheGph[DCF_GRAPH_SIZE+1]; /* hpfs386 cache write graph*/
  USHORT        cpuMagPct;                       /* CPU magnified percent    */
  USHORT        cpuAvgPct;                       /* CPU average percent      */
  USHORT        cpuIdlePct;                      /* CPU idle percent         */
  USHORT        cpuCurrPct;                      /* CPU current percent      */
  CHAR          cpuCurrGph[DCF_GRAPH_SIZE+1];    /* CPU current graph        */
  ULONG         winCount;                        /* total open windows       */
  ULONG         fileCount;                       /* total open files         */
  USHORT        tidCount;                        /* total threads            */
  DOUBLE        osVer;                           /* OS/2 version             */
  USHORT        cpuCnt;                          /* processors in machine    */
  CHAR          userDefined[DCF_USER_SIZE+1];    /* user defined monitor     */

  USHORT        eventSwpGrowCnt;                 /* swap event count         */
  ULONG         eventSwpGrowLAmt;                /* swap event last bytes    */
  LONG          eventSwpGrowLTime;               /* swap event last time     */
  USHORT        eventCpuAvgCnt;                  /* avg cpu event count      */
  USHORT        eventCpuAvgLAmt;                 /* avg cpu event last pct   */
  LONG          eventCpuAvgLTime;                /* avg cpu event last time  */
  USHORT        eventVRamFreeCnt;                /* vram event count         */
  ULONG         eventVRamFreeLAmt;               /* vram event last bytes    */
  LONG          eventVRamFreeLTime;              /* vram event last time     */
  USHORT        eventDrive1Cnt;                  /* drive1 event count       */
  DOUBLE        eventDrive1LAmt;                 /* drive1 event last bytes  */
  LONG          eventDrive1LTime;                /* drive1 event last time   */
  USHORT        eventDrive2Cnt;                  /* drive2 event count       */
  DOUBLE        eventDrive2LAmt;                 /* drive2 event last bytes  */
  LONG          eventDrive2LTime;                /* drive2 event last time   */
  USHORT        eventDrive3Cnt;                  /* drive3 event count       */
  DOUBLE        eventDrive3LAmt;                 /* drive3 event last bytes  */
  LONG          eventDrive3LTime;                /* drive3 event last time   */
  USHORT        eventDrive4Cnt;                  /* drive4 event count       */
  DOUBLE        eventDrive4LAmt;                 /* drive4 event last bytes  */
  LONG          eventDrive4LTime;                /* drive4 event last time   */
  USHORT        eventDrive5Cnt;                  /* drive5 event count       */
  DOUBLE        eventDrive5LAmt;                 /* drive5 event last bytes  */
  LONG          eventDrive5LTime;                /* drive5 event last time   */
  USHORT        eventDrive6Cnt;                  /* drive6 event count       */
  DOUBLE        eventDrive6LAmt;                 /* drive6 event last bytes  */
  LONG          eventDrive6LTime;                /* drive6 event last time   */
  USHORT        eventBatFreeCnt;                 /* battery event last pct   */
  ULONG         eventBatFreeLAmt;                /* battery event count      */
  LONG          eventBatFreeLTime;               /* battery event last time  */
  USHORT        eventSwpFreeCnt;                 /* swap free event count    */
  ULONG         eventSwpFreeLAmt;                /* swap free event last byte*/
  LONG          eventSwpFreeLTime;               /* swap free event last time*/
  USHORT        eventRamFreeCnt;                 /* ram free event count     */
  ULONG         eventRamFreeLAmt;                /* ram free event last bytes*/
  LONG          eventRamFreeLTime;               /* ram free event last time */

  USHORT        pidCount;                        /* total PIDs in DCFPSTATS  */
  DCFPSTATS     pstatTbl[DCF_PSTATS_SIZE];       /* process status table     */
} DCFSTATS, *PDCFSTATS;
#pragma pack()

/* prototypes */
#ifdef __cplusplus
extern "C" {
#endif

APIRC APIENTRY DCFGetStats    (PDCFSTATS pDCFStatsOut);
BOOL  APIENTRY DCFVerify      (void);
APIRC APIENTRY DCFUserDefined (PCHAR buffer);
BOOL  APIENTRY PMPShutDown    (void);

#ifdef __cplusplus
}
#endif
#endif
