/*------------------------------------------------------------------------*\
|                                                                          |
|                Create CFSPoker Program object on Desktop                 |
|                                                                          |
\*------------------------------------------------------------------------*/
/*
   This program will create a program object for CFSPoker on your
   Desktop.
*/

/*----------------------------*\
|  Be sure REXXUTIL is loaded  |
\*----------------------------*/
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

CFSPoker_path_and_file_name =,
   STREAM( 'CFSStart.EXE', 'C', 'QUERY EXISTS' )
CFSPoker_path =,
   FILESPEC( 'D', CFSPoker_path_and_file_name ) ||,
   FILESPEC( 'P', CFSPoker_path_and_file_name )

location = '<WP_DESKTOP>'
class    = 'WPProgram'
title    = 'CFSPoker'
setup_string =,
   'EXENAME=' || CFSPoker_path || 'CFSStart.exe'     || ';' ||,
   'PARAMETERS='                                     || ';' ||,
   'STARTUPDIR=' || STRIP( CFSPoker_path, 'T', '\' ) || ';' ||,
   'OBJECTID=<CFSPoker>;'

call SysCreateObject class, title, location, setup_string, 'R'
if RESULT = 1 then
   do
      say 'CFSPoker object created'
      '@start view' CFSPoker_path || 'CFSPoker.INF Welcome'
   end
else
   do
      say 'Unable to create CFSPoker object'
   end
