/*
   Ŀ
                       Getmail - R.Cougnenc 1991                           
                                                                           
       Creates an ASCII file of all the messages addressed to a            
       specific user in a PCBoard message base.                            
                                                                           
       Each message is then killed on the board.                           
                                                                           
   
*/

#include <stdio.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>


#define OK     0
#define ERROR  1
#define MAXMSG 32512

/*--------------------------------------------------------------------------*/
main(int argc, char **argv)
{
    int fd,fo ;
    int head ;

    if( argc < 4 )
    return usage() ;

    if( access( argv[1], 0 ) )
        return usage() ;

   if(  (fd = open(argv[1],O_RDWR | O_BINARY ) ) == -1 )
   {
        fprintf(stderr,"Impossible d'accder au fichier %s\n",argv[1] );
        return usage();
   }

   if(  (fo = open(argv[3],O_RDWR | O_CREAT | O_APPEND | O_TEXT ) ) == -1 )
   {
        fprintf(stderr,"Cannot open the file %s\n",argv[3] );
        return usage();
   }

   head = strupr(argv[4])[0] == 'H' ?  1 : 0 ;

   lseek( fd, 128L, SEEK_SET );   /* passe the message base header */

   fprintf(stderr,"Getmail by R.Cougnenc, Scanning %s:  ",argv[2]);
   mouline( fd,argv[2],fo,head );
   fprintf(stderr,"\rGetmail by R.Cougnenc, Done.                    ",argv[2]);

  close( fd ) ;
  close( fo ) ;
  return OK   ;
}
/*--------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------*/
usage()
{
    printf("\nUsage : Getmail msgbase \"USERNAME\" outfile [header]\n\n" );
    printf("       MSGBASE is the name of the PCBoard messages base \n"
           "        to use.\n\n" );
    printf("       USERNAME is the full name of the user to scan and extract\n"
           "        the messages.\n\n"
           "        If there are more than one word, put it in quotes.\n"
           "        !!! Search is case-sensitive !!!\n\n" );
    printf("       OUTFILE is the  ASCII file that will receive the messages\n"
           "        being extracted. It is opened in 'append mode'.\n\n" );
    printf("       HEADER is optional. If this flag is used, the messages will\n"
           "        have the following header (From: To: Sujet, date, time).\n"
           "        If it is not used, the body of the messages will simply be\n"
           "        added to each other\n\n" );

    printf("Example: GetMail c:\\pcb\\main\\msgs \"RENE COUGNENC\" mail.txt header\n\n");

    printf("     <<< EACH EXTRACTED MESSAGE IS KILLED IN THE MESSAGE BASE >>>\n");
    return ERROR ;
}
/*--------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------*/
/*
                            The program itself.
*/
mouline( int fd, char *user, int fo ,int head)
{
    int status ;
    long curpos ;
    char buf[128] ;
    int len = strlen(  user );
    char *msgbuf ;


    if(( msgbuf = (char *) malloc(MAXMSG)) == NULL )
    {
        fprintf(stderr,"Not enough memory.\n");
        return  ERROR ;
    }

    while(1)
    {
        visu();
        curpos = tell( fd );
        if( (read( fd, buf , 128 )) <= 0 )
             break ;  /* end of file... */

                                /* User found and message isn"t killed: */

        if(! strncmp( buf +23, user, len ) && buf[120] != '')
        {
            read( fd, msgbuf, (buf[9] -1) * 128 ); /* read the message..      */
            printmsg(buf,msgbuf,fo,head);    /* extract the message...       */
            buf[120]  = '';                 /* Kill the message.           */
            lseek( fd, curpos, SEEK_SET ) ;  /* Go back to the header.... */
            write( fd , buf , 128 ) ;        /* Write the header back...    */
            lseek( fd , (long ) (buf[9] -1 ) * 128, SEEK_CUR );
                                             /* Check next message. */
        }

    
    }

    free( msgbuf );
    return OK ;
}
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/*
        Display a spinning little arrow at each use.
        Fun, et it shows that the program is runing.
*/

visu()
{
    static int i = 0 ;
    static char t[4] = {'<','','>',''} ;
    fprintf(stderr,"\b%c",t[i++] );
    if( i > 3 )
       i = 0 ;
}
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/*
        Extraction of the message with or without header if fo.
*/

printmsg(char *buf, char *msgbuf, int fo, int head)
{
 static  char from[30], to[30],
         date[10], heure[10],
         subject[30], str[1024];
         char *ptr = msgbuf ;
         int len,i ;

        len = (buf[9] -1 ) * 128 ;  /* message length       */
        if( head )                  /* if header was asked. */
        {
            strncpy(from, buf + 58, 25 );
            strncpy(to, buf + 23, 25 );
            strncpy(date, buf + 10, 8 );
            strncpy(heure, buf + 18, 5 );
            strncpy(subject, buf + 83, 25 );

            from[25] = to[25] = '\0' ;
            sprintf(str,"\n\nFrom : %s\n", from );
            sprintf(str,"  To : %s\n", to   );
            sprintf(str," Subject : %s\n", subject );
            sprintf(str,"  Date : %s (%s)\n\n", date,heure);
            sprintf(str,"\n\n   From : %s\n     To : %s\nSubject : %s\n   Date : %s (%s)\n\n\n",
                    from,to,subject,date,heure );
            write(fo,str, strlen(str) );
        }

       for( i = 0 ; i < len ; i++ )     /* Use ASCII format */
       {
           if( *ptr == '' )
              *ptr = '\n';
           ptr++;
       }
       ptr--;

       while( *ptr == ' ' )            /* Cleanup the last block.*/
       {
          *ptr-- = '\0';
          len--;
       }

       write( fo, msgbuf , len ) ;
       write( fo,"\n", 1 );
}
/*--------------------------------------------------------------------------*/
