@echo off
REM Example batch file to generate a downloadable files listing using
REM PCBoard's PCBFILER, Sam Smith's DIRCOUNT, Michael Nelson's STRIPIT,
REM and Phil Katz's PKZIP utilities.

cls
c:
cd\pcb

REM The next line runs Sam Smith's DIRCOUNT program to generate the
REM header files for the DIR files.
dircount dircount.cnf >c:\pcb\gen\blt99

REM Check for the existence of PCBFILES.LST or SEAHUNT.LST, and delete
REM if found
if exist pcbfiles.lst del pcbfiles.lst >NUL
if exist seahunt.lst del seahunt.lst >NUL

REM Next, generate the PCBFILES.LST with PCBFILER
pcbfiler /list
echo.
echo.
echo.

REM Now we run STRIPIT to remove those annoying lines from the list
StripIt pcbfiles.lst
echo.
echo.
echo.

REM Rename PCBFILES.LST to your chosen filename
ren pcbfiles.lst seahunt.lst >NUL

REM Freshen the archive containing your compressed, downloadable list
pkzip -f f:\misc\seahunt.zip