; ----------------------------------------------------------------------------
; FERRET V1.01 Configuration Control File
; ----------------------------------------------------------------------------

;        LogFiles
;
;             Following   this   keyword,  you   must   enter   a  complete
;             path/filename to  your front-end  log file,  and report file.
;             You  may use  a  maximum of  128  entries with  this keyword,
;             making  multi-node configurations  possible.  Entries  to the
;             report  file reflect  record adjustments,  request filenames,
;             and  totals.  It  is suggested  you  review this  report file
;             before deleting it.
;
;        Front-end log file                Report file
;        --------------------------------  --------------------------------
logfiles d:\bt0\log\bt1.log                d:\matrix\ferret\ferret.rpt
logfiles d:\bt0\log\bt2.log                d:\matrix\ferret\ferret.rpt

;        Pcbdat
;
;             Enter the complete path/filename  to your primary PCBoard.dat
;             file.  Ferret  will use  Pcboard's data  file to  gather path
;             information on your userfile,  index files, fsec, and minimum
;             download security level.
;
pcbdat   d:\pcb0\pcboard.dat

;        DlPath
;
;             Complete path/filename of download path list file.  This file
;             is identical  to Pcboard's dlpath.lst  file.  In  fact, it is
;             expected  you  use  the   same  one  specified  in  Pcboard's
;             configuration.
;
dlpath   e:\locl\main\dirs\dlp.lst
dlpath   e:\locl\alde\dirs\dlp.lst

;        MstrList
;
;             Master password control path and filename.  It is referred to
;             as the 'Master' password file  since it's values are exported
;             to other text  files.  Nodelist compilers  would then use the
;             exported information  to assign session  passwords within the
;             nodelist.
;
mstrlist d:\matrix\ferret\password.ctl

;        ExportLst
;
;             Path/filename  used  to  export  nodelist  information.   ie:
;             address, password,  etc.  The  format this  information takes
;             may be configured with the exportfmt keyword.
;
exportlst d:\matrix\nodelist\xlaxnode.pwd

;        ExportFmt
;
;             Each node listed  in the Master  list may be  exported to the
;             external password file, outlined above.  The format which the
;             exported  information takes  is  controlled by  three macros;
;             @address@,  @password@,  and  @name@.   Other  values  may be
;             included and would be transferred relative to the macros.
;
exportfmt @address@ @password@

