/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                   Common Include Files for BinkleyTerm                   */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*
 * This file drives all the defines and includes in BinkleyTerm. In
 * here we handle cross-compiler portability issues. It was originally
 * born to make compiled headers (a neat feature of Borland C) work,
 * but the other role quickly caught on as well.
 *
 * Some of the portability stuff will no doubt wind up in other Bink
 * include files -- but the system-level stuff such as utime, etc
 * is all dealt with here.
 *
 * All main Bink modules should include this file before any specific
 * local includes.
 *
 */

/* System include files */

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>
#include <process.h>
#include <stdlib.h>
#include <stdarg.h>
#include <io.h>

#ifndef __IBMC__				/* CSET2 */
#include <dos.h>
#endif

#include <errno.h>
#include <time.h>
#include <fcntl.h>
#include <share.h>

/*
 * Compiler-specific stuff. The baseline in this sucker is
 * Microsoft C 6.00a. Below what you see are the includes and
 * macros we need to differentiate individual compilers from
 * the baseline.
 *
 * The easiest way to add a new compiler is to replicate the
 * _MSC_VER section using whatever manifest constant your
 * compiler uses to identify itself, then do the fixups in
 * that section.
 *
 * Be sure to put your section before that last define for
 * COMPILER_NAME!
 *
 */

#ifdef __TURBOC__				/* Borland C++ 2.0                */
/*
 * Borland.
 *
 * No sharing stream open. (s)open/fdopen works, though.
 * Signal call is non-generic and incompatible
 * Read/Write to far memory in near model not implemented
 * Console output non-generic
 * No utime call
 *
 */

#ifdef __BORLANDC__
#define COMPILER_NAME   "-Borland"
#else
#define COMPILER_NAME   "-Turbo"
#endif
#define MUST_FDOPEN			/* Share streams: sopen+fdopen    */
#define NO_SIGNALS			/* Don't install a signal handler */

#ifdef OS_2
#include <utime.h>

typedef struct utimbuf UTIMBUF;

#define UT_ACTIME actime
typedef long off_t;

#include <sys\types.h>
#include <sys\stat.h>
#include <mem.h>
#include <dir.h>
#include <alloc.h>
#define _fmalloc(n) malloc (n)
#define _ffree(n) free (n)
#undef sopen					/* we don't want to use all the args */
#define sopen(a,b,c) open (a, b|c)
typedef void _cdecl SIGTYPE;
#define SIGARGS void
typedef void _cdecl MAINTYPE;
#define far
#define __32BIT__
#define _Far16 __far16
#define _Seg16 __far16
#define _Pascal __pascal
#else /* Not OS/2 */

/* uncomment the following line for BC++ 2.0              */
/*#define __TURBOC_OLD__ */

#define NEED_CPUTS			/* Need our own cputs             */
#define NEED_PUTCH			/* Need our own putch             */
#define NEED_CPRINTF			/* Need our own cprintf           */

#ifdef __TURBOC_OLD__
#define NEED_DOSREAD			/* Need our own _dos_(read/write) */
struct utimbuf
{
	time_t actime;				/* access time */
	time_t modtime;			/* modification time */
};
int cdecl utime (char *, struct utimbuf *);
#endif							/* __TURBOC_OLD__ */

#ifndef __TURBOC_OLD__
#include <utime.h>
#endif

typedef struct utimbuf UTIMBUF;

#define UT_ACTIME actime
typedef long off_t;

#if __BORLANDC__ >= 0x410
#include <sys\types.h>
#include <sys\stat.h>
#else
#include <types.h>
#include <stat.h>
#endif

#include <mem.h>
#include <dir.h>
#include <alloc.h>
#define _fmalloc(n) farmalloc (n)
#define _ffree(n) farfree (n)
#undef sopen					/* we don't want to use all the args */
#define sopen(a,b,c) open (a, b|c)
typedef void _cdecl SIGTYPE;
#define SIGARGS void
typedef void _cdecl MAINTYPE;

#endif /* OS_2 */
#endif /* defined __TURBOC __ */

#ifdef _MSC_VER				/* Microsoft C 5.1 or 6.0a        */
/*
 * Microsoft.
 *
 * By and large, it's Microsoft compatible <grin>
 *
 * MSC 5.10 and below has no way to open a stream in
 * sharing mode. sopen/fdopen doesn't work.
 *
 */

#if _MSC_VER == 510
#define COMPILER_NAME   "-uSoft5.1"
#endif
#if _MSC_VER == 600
#define COMPILER_NAME   "-uSoft6.0"
#endif
#if _MSC_VER == 700
#define COMPILER_NAME   "-uSoft7.0"
#define ANSI_TIME_T
#endif
#if _MSC_VER == 800
#define COMPILER_NAME   "-uSoft8.0"
#pragma warning ( disable : 4746 )	/* Unsized arrays treated as __far */
#endif
#if _MSC_VER < 600
#define CANT_FSOPEN
#endif
#include <sys\types.h>
#include <sys\stat.h>
#include <sys/utime.h>
typedef struct utimbuf UTIMBUF;
#define UT_ACTIME actime
#include <memory.h>
#include <direct.h>
#include <malloc.h>
typedef void _cdecl SIGTYPE;
#define SIGARGS int sigarg
#define SIGNAL_ARGUMENT
typedef void _cdecl MAINTYPE;

#endif /* defined _MSC_VER */

#ifdef __IBMC__				/* IBM C Set/2   */
/*
 * IBM.
 *
 * By and large, it's Microsoft compatible <grin>
 * At the moment we have to use the migration libs.
 *
 */

#define COMPILER_NAME   "-IBMC/2"
#include <sys\types.h>
#include <sys\stat.h>
#include <sys/utime.h>
typedef struct utimbuf UTIMBUF;

#define UT_ACTIME actime
#include <memory.h>
#include <direct.h>
#include <malloc.h>
#define MUST_FDOPEN			/* Share streams: sopen+fdopen    */
#define NEED_MKTEMP			/* Need our own mktemp            */
typedef void SIGTYPE;

#define SIGARGS int sigarg
#define SIGNAL_ARGUMENT
typedef int MAINTYPE;
#define BINKLEY_SOUNDS      /* Use MMPM/2 to play sounds      */
#define TIMEZONE _timezone
#ifndef __32BIT__
#define __32BIT__
#endif /* defined __32BIT__ */
#endif /* defined __IBMC__ */

#ifdef __WATCOMC__			/* WATCOM C++ 9.5, thanks to SJD  */
/*
 * WATCOM.
 *
 * No sharing stream open. sopen/fdopen doesn't work.
 * No mktemp call
 * utime structure member naming different
 *
 */

#ifdef __FLAT__
#define __32BIT__
#define COMPILER_NAME   "-WATCOM C/32"
#else
#define COMPILER_NAME   "-WATCOM"
#endif

#define MUST_FDOPEN			/* Share streams: sopen+fdopen    */
#define SHARE_SOPEN			/* Share streams: sopen, not open */
#define NEED_MKTEMP			/* Need our own mktemp            */
#include <sys\types.h>
#include <sys\stat.h>
#include <sys\utime.h>
typedef struct utimbuf UTIMBUF;

#define UT_ACTIME actime
#include <direct.h>
#include <malloc.h>

#define SIGTYPE void
#define SIGARGS int sigarg
typedef void MAINTYPE;

#ifdef __FLAT__
#define _osmode OS2_MODE
#define _fmalloc(n) malloc(n)
#define _ffree(p)   free(p)
#endif

#endif /* defined __WATCOMC__ */

#ifdef __ZTC__					/* Zortech C++ 3.0 */
/*
 * Zortech.
 *
 * No sharing stream open. sopen/fdopen doesn't work.
 * Signal handler stuff incompatible
 * Read/Write to far memory in near model not implemented
 * No console I/O functions
 * No mktemp call
 * utime doesn't use a structure
 * no ultoa, we use more limited ltoa
 * tzset not there or needed
 *
 */

#define COMPILER_NAME   "-Zortech"
#define CANT_FSOPEN			/* No way to share streams        */
#define SHARE_SOPEN			/* Share streams: sopen, not open */
#define NO_SIGNALS			/* Don't install a signal handler */
#define NEED_DOSREAD			/* Need our own _dos_(read/write) */
#define NEED_CPUTS			/* Need our own cputs             */
#define NEED_PUTCH			/* Need our own putch             */
#define NEED_MKTEMP			/* Need our own mktemp            */
#include <sys\types.h>
#include <sys\stat.h>
struct utimbuf
{
	time_t actime;				/* access time */
	time_t modtime;			/* modification time */
};
typedef time_t UTIMBUF;		/* ZTC utime uses a time_t array  */

#define UT_ACTIME actime
#ifdef __VCM__
#define __LARGE__				/* VCM model same as large, really*/
#endif
typedef long off_t;

#include <direct.h>
#define _fmalloc(n) farmalloc (n)
#define _ffree(n) farfree (n)
#define ultoa(x,y,z) ltoa((long)x,y,z)
#define stricmp(x,y) strcmpl(x,y)
#define _dos_setdrive(x,y) dos_setdrive(x,y)
#define tzset()
typedef void _cdecl SIGTYPE;

#define SIGARGS void
typedef void _cdecl MAINTYPE;

#endif /* defined __ZTC__ */

/*
 * Make sure there's at least a zero-length string for
 * the compiler name.
 *
 * THIS LINE SHOULD ALWAYS BE LAST!
 *
 */

#ifndef COMPILER_NAME
#define COMPILER_NAME   ""
#endif

#ifdef ANSI_TIME_T
#define ANSI_TIME_T_DELTA 2209075200L
#endif

#define DOS16

#ifdef OS_2
#undef DOS16
#endif

#ifdef _WIN32

#define far
#define pascal
#define WINAPI      __stdcall
#define UCT_DIFFERENTIAL _timezone
#define ANSI_TIME_T
#define ANSI_TIME_T_DELTA (_timezone)	/* amazingly, this just works! */
#define NEED_DOSREAD			/* Need our own _dos_(read/write) */
#define BINKLEY_SOUNDS		/* NT can make noise! */
#define real_flush(a) _commit(a)
#define _fmalloc malloc
#define _ffree free
typedef unsigned short USHORT;
typedef unsigned long ULONG, HANDLE;
typedef long DWORD;
typedef int HFILE;
typedef unsigned char *PCH;
typedef unsigned short HVIO;

#define COMFILE_PREFIX ""
#define COMFILE_SUFFIX ".BAT"
#define SHARE_DEFAULT 1
#define BBS_SPAWN
typedef unsigned char *PSZ;
#pragma warning (disable: 4201 4244)
#undef DOS16

#endif /* defined _WIN32 */

#ifdef DOS16

typedef unsigned short USHORT;
typedef unsigned long ULONG;
typedef long DWORD;
typedef unsigned char BYTE;
typedef unsigned short BOOL;

typedef int HFILE;
typedef unsigned char far *PCH;
typedef unsigned short HVIO;

#define HAVE_HYDRA
#define LOCALFUNC _near _fastcall
#define hfComHandle (port_ptr + 1)
#define COMFILE_PREFIX ""
#define COMFILE_SUFFIX ".BAT"
typedef unsigned char far *PSZ;
#define SHARE_DEFAULT 0

#endif /* defined DOS16 */

#ifdef OS_2
#define INCL_NOPM
#define INCL_BASE
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_DOSDEVIOCTL
#include <os2.h>
#include "maxcomm.h"			/* moved here to avoid hcModem undefined        WRA */

#ifndef __WATCOMC__
#define _dos_read DosRead
#define _dos_write DosWrite
#endif /* __WATCOMC__ */

#define COMFILE_PREFIX ""
#define COMFILE_SUFFIX ".CMD"
#define SHARE_DEFAULT 1
#define BBS_SPAWN
#define HAVE_HYDRA
#ifdef __32BIT__
#define LOCALFUNC
#else
#define LOCALFUNC _near
#endif
#ifndef TIMEZONE
#define TIMEZONE timezone
#endif
#endif /* defined OS_2 */

#define isBITBRAIN 0x1b

#ifndef LOCALFUNC
#define LOCALFUNC
#endif

/* Local include files */
#include "bink.h"
#include "defines.h"
#include "com.h"
#include "xfer.h"
#include "msgs.h"
#include "zmodem.h"
#include "keybd.h"
#include "keyfncs.h"
#include "sbuf.h"
#include "sched.h"
#include "timer.h"
#include "vfossil.h"
#include "externs.h"
#include "prototyp.h"

