#include <stdio.h>
#include <stdlib.h>
#include <process.h>

#define CR "\r\n"

display_instructions(){
	char *str="" CR
"PURPOSE: Executes program (with its arguments).  Upon termination of program"CR
"         ERRCD will return the ERRORLEVEL of the program.  This may help you"CR
"         in the design of batch files" CR CR
"  USAGE: ERRCD program [arg ... ...]" CR CR
"   NOTE: The programs errorlevel is returned by ERRCD so it remains"CR
"         transparent to the programs operation." CR CR;
	printf("%s",str);
}

main(int argc,char *argv[]){
	int status;
	if(argc<2)	{
		display_instructions();
		exit(1);
	}
	if((status=spawnvp(P_WAIT,argv[1],&argv[1]))==-1){
		if(errno==2) display_instructions();
		perror("\n\n\bERRCD encounted an error!");
		printf("\nReturning ERRORLEVEL=1\n");
		exit(1);
	}
	printf("\n\nERRORLEVEL = %d\n",status);
	exit(status);
}