#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

void main(int argc, char **argv) {
  char static *ConfigSysFile = "d:\\CONFIG.SYS";
  char static *ConfigTmpFile = "d:\\CONFIG.TMP";
  char Buffer[256];
  int  Drive;
  int  Size;
  FILE *In;
  FILE *Out;

  if (argc < 3) {
    puts("Usage:   SETSHELL A: 1024\n"
         "\n"
         "Description:  Modifies the CONFIG.SYS file on the specified drive\n"
         "adding (or modifying) a SHELL= statement making it look like the\n"
         "following:\n"
         "               SHELL=d:\COMMAND.COM /E:n /P\n"
         "\n"
         "where 'd:' is the drive you specify and 'n' is the number of bytes\n"
         "you specify for the environment\n");
    return;
  }

  Drive = toupper(argv[1][0]);
  if (Drive < 'A' || Drive > 'Z') {
    printf("%c: drive letter out of range (A-Z)\n",argv[1]);
    return;
  }

  Size = atoi(argv[2]);
  if (Size < 16 || Size > 2048) {
    printf("%s: environment size out of range (16-2048)\n",argv[2]);
    return;
  }

  ConfigSysFile[0] = ConfigTmpFile[0] = Drive;   /* get the drive letter */

  if ((In = fopen(ConfigSysFile,"rt")) == NULL) {
    printf("unable to open config.sys file: %s\n",ConfigSysFile);
    return;
  }

  if ((Out = fopen(ConfigTmpFile,"wt")) == NULL) {
    printf("unable to create config.tmp file: %s\n",ConfigTmpFile);
    return;
  }

  while (fgets(Buffer,sizeof(Buffer),In) != NULL) {
    strupr(Buffer);
    if (strstr(Buffer,"SHELL") != NULL)
      continue;   /* skip this line and we'll add our own later */
    fputs(Buffer,Out);
  }

  fprintf(Out,"SHELL=%c:\\COMMAND.COM /E:%d /P",Drive,Size);
  fclose(Out);
  fclose(In);
  unlink(ConfigSysFile);
  rename(ConfigTmpFile,ConfigSysFile);
}
