/*

                    ATTIRUN - R.Cougnenc 1991 - Domaine Public

    Utilitaire ralis spcialement pour ATTILA ALTAN pour ses petits
    besoins personnels.

    Compilation : Turbo-c / quick-c / MSC / et caetera.

    Ce programme excute un autre programme, qui n'est pas recherch sur
    le disque pour gagner du temps mais dans un fichier de configuration
    amoureusement prpar par Attila.

    Il change le rpertoire courant pour celui prcis pour le programme,
    execute le machin, et contrairement  r.c reste dans ce rpertoire.

    Ca permet de faire un spawn OVERLAY et de ne pas bouffer de mmoire.


*/

#include <stdio.h>
#include <string.h>
#include <process.h>

#define    OK         0
#define    ERROR     -1
#define    EOS        0
#define    MAXP       80
#define    SEP       '/'
#define    SEPDOS    '\\'
#define    PROGRAMME "e.com"
#define    CONFNAME  "e.cfg"

char HomePath  [MAXP]; /* Home directory du programme               */
char FileConf  [MAXP]; /* Le mme avec le nom de la config derriere */
char OldDir    [MAXP]; /* Rpertoire courant sauvegard             */
int SaveDrive;         /* Le disque courant sauvegard              */

char Prog2run  [MAXP]; /* Le programme  xcuter, dans la    config */
char Path2go   [MAXP]; /* Le path o aller, dans le fichier config   */

/*----------------------------------------------------------------------*/
main(int argc, char **argv)
{
    int NewDrive ;

    if( argc < 2 )
       return usage();


    MakeHomePath(argv[0]);          /*   Creation du  fichier config */
    strcpy(FileConf,HomePath );
    strcat(FileConf,CONFNAME );

    if( search(argv[1] ) )          /* Lecture fichier config        */
       return usage();


    if(chdir(Path2go) == -1 )        /* Change le path courant        */
    {
        printf("Impossible d'aller en %s !\n",Path2go );
        return ERROR ;
    }

    if( Path2go[1] == ':' )         /* Cas d'une autre unit disque   */
    {
        NewDrive = Path2go[0] ;
        NewDrive = NewDrive > 'Z' ?  NewDrive - 32 : NewDrive ;
        SetDisk(NewDrive - 'A' );
    }


    execv(Prog2run,++argv);  /* Lancement Programme */

}
/*--------------------------------------------------------------------*/


/*--------------------------------------------------------------------*/
/*
 * SEARCH : cherche le programme dans le fichier de config, remplit les
 *	    variables globales correspondantes.
 *
 *	    Retourne 0 si succes, 1 si erreur ou pas trouv
 */
search(char *prog)
{
   FILE *fp ;
   char line [256];
   int i = 0 ;


    strlwr(prog) ;           /* Passe le nom en minuscules et vire */
    StopExt(prog);           /* l'extension dont on se fout.       */

    if( (fp = fopen(FileConf,"r") ) == NULL )
	{
		printf("\nFichier %s introuvable !\n",FileConf);
		return ERROR ;
	}
	setvbuf(fp,NULL,_IOFBF,4096) ; /* un cluster souvent */

	while(fgets(line,255,fp) )
	{
        i++ ;

	       if( line[0] == '#' || strlen( line ) < 2 )
		      continue ;
	       Prog2run[0] = Path2go[0] = 0 ;
	       sscanf(line,"%s%s", Prog2run, Path2go );
           if( !Path2go[0] )
           {
               printf("Erreur dans le fichier de configuration ligne %d\n",i);
               printf("(Pas de chemin indiqu pour %s)\n",Prog2run) ;
               fclose(fp);
               return ERROR ;
           }
	       strlwr(Prog2run) ;
           StopExt(Prog2run);
	       if(! strcmp(Prog2run,prog) )
	       {
        	    fclose(fp);
	            return OK ;
	       }
	}

    fclose(fp );
    printf("\n%s pas trouv dans la configuration.\n",prog);
    return ERROR ;
}
/*--------------------------------------------------------------------*/


/*--------------------------------------------------------------------*/
/*
 *     No comment :-)
 */
usage()
{
    printf("ķ\n");
    printf(" E.COM    Ren Cougnenc 1991  Domaine Public \n");
    printf("                                               \n");
    printf(" Utilitaire destin   Attila  ALTAN, ralis  \n");
    printf(" sur ses spcifications, pour son merveilleux  \n");
    printf(" serveur qu'est LI'LL BBS.                     \n");
    printf("Ľ\n");

    printf("\nUsage : E programme [ arguments ]\n");
}
/*--------------------------------------------------------------------*/



/*--------------------------------------------------------------------*/
/*
 * MakeHomePath : Recupere le home directory  du programme
 *
 *
 */

MakeHomePath(path)
char *path;
{
 int i;
 char *pt;

        strcpy(HomePath,path);
        i = strlen(HomePath);
	while(i)
	{
                if(HomePath[i] == SEP || HomePath[i] == ':'||
                   HomePath[i] == SEPDOS ) break ;
		HomePath[i] = 0;
		i--;
	}

   pt = HomePath ;
   while(*pt)
   {
     if( *pt == SEPDOS )
       *pt = SEP ;
     pt++;
   }
}
/*----------------------------------------------------------------------*/



/*----------------------------------------------------------------------*/
/*
 * SETDISK : change l'unit de travail, normalise les choses entre
 *
 */
SetDisk( int drive )
{
#ifdef __TURBOC__
        setdisk(drive );
#else
 int m = 26 ;
        _dos_setdrive(drive + 1, &m);
#endif
}

/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*
 *  STOPEXT : Supprime l'extension d'un nom de fichier .
 *
 */
StopExt(char *ptr )
{
    while( *ptr )
    {
        if( *ptr == '.' )
        {
           *ptr = 0 ;
           break ;
        }
        ptr++ ;
    }
}
/*----------------------------------------------------------------------*/
