/* ******************************************************************** *

   ISTHERE 1.00, Copyright (c) 1992, Bob Flanders and Michael Holmes
   Check for free space

   Usage: ISTHERE n [d:]

   Where: n  is a number for an absolute number of bytes (e.g. 50000)
	     is nK to check in K bytes (e.g. 250K)
	     is nM to check in M bytes (e.g. 2M)
	  d: is the drive to check

   DOS Errorlevel: 0 = Yes, at least that much on drive
		   1 = No, less space on drive
		   2 = Other error (syntax error, drive not ready, etc.)

   Example: ISTHERE 12M C:
		Returns 0 if 12 megabytes or more space is availalble
		on drive C:

 * ******************************************************************** *

   This code is for Borland C++ version 3.0.

 * ******************************************************************** */


#pragma  pack(1)                            /* pack to byte alignment   */
#include <stdio.h>                          /* standard i/o library     */
#include <string.h>			    /* string function def's	*/
#include <stdlib.h>			    /* common types, etc	*/
#include <ctype.h>			    /* ctype macros		*/
#include <dir.h>			    /* get working directory	*/
#include <dos.h>                            /* DOS rtn definitions      */

#define UINT unsigned int                   /* unsigned integer type    */
#define ULONG unsigned long		    /* unsigned long type	*/
#define NOT !                               /* logical not              */
#define MAX_PATH 79                         /* max path length          */


/* ******************************************************************** *
 *      routine definitions                                             *
 * ******************************************************************** */

void    quit_with(int, char *),             /* quit with error message  */
	interrupt critical_handler(UINT,    /* critical error handler   */
	    UINT, UINT, UINT, UINT, UINT,
	    UINT, UINT, UINT, UINT, UINT,
	    UINT);

int	control_break(void);                /* control break handler    */

/* ******************************************************************** *
 *      globals                                                         *
 * ******************************************************************** */

int     init_drive,                         /* startup drive            */
	rc = 2;                             /* bad parmaeters           */

unsigned
long    avail_space,                        /* available bytes on disk  */
	check_for;			    /* amount to check for	*/

char    drive[] = " :",                     /* drive being checked      */
	drive_nbr;                          /* drive nbr (1 = A)        */


/* ******************************************************************** *
 *      messages and strings                                            *
 * ******************************************************************** */

char    copyright[]    = "ISTHERE 1.00 \xfe Copyright (c) 1992, "
			 "Bob Flanders and Michael Holmes\n"
			 "Check free space on drive\n\n",
	enuf_space[]   = "Yes, there are",
	insuf_space[]  = "No, there are only",
	space_msg[]    = "%s %ld bytes available on drive %s.\n",
	bad_op[]       = "Invalid parameter %s\n",
	stop_here[]    = "\nStopping at user's request\n",
	bad_drive[]    = "Invalid drive specified or drive not ready.\n",
	bad_number[]   = "The number must be n, nK or nM.\n",
	gtzero[]       = "You should check for more than zero bytes.\n",
	help[]         = "Usage:  ISTHERE n [d:]\n\n"
			 "Where:  n  is number (n, nK or nM)\n"
			 "        d: is the drive to check\n\n";


/* ******************************************************************** *
 *      structures                                                      *
 * ******************************************************************** */

struct diskfree_t freespace;                /* free space structure     */


/* ******************************************************************** *
 *      main()                                                          *
 * ******************************************************************** */

int     main(int  ac,                       /* DOS cmd line token count */
	     char *av[])                    /* ..token strings          */
{
char    *p;                                 /* positional parm pointer  */

printf(copyright);                          /* give copyright message   */

ctrlbrk(control_break);                     /* set up ctrl break and    */
_dos_setvect(0x24, critical_handler);       /* ..DOS critical handlers  */

_dos_getdrive((UINT *) &init_drive);        /* get the default drive    */
drive_nbr = init_drive;                     /* ..set up default drive   */
*drive = init_drive + 'A' - 1;              /* ..nbr and ASCII string   */

/* ********************* *
 *  validate parameters  *
 * ********************* */

if ((ac < 2) || (ac > 3))		    /* q. wrong number of parms?*/
    quit_with(1, "");    		    /* a. yes .. display help	*/

if (ac == 3)                                /* q. drive given?          */
    {
    p = av[2];                              /* a. yes .. get pointer    */

    if ((strlen(p) == 2) && p[1] == ':')    /* q. valid size and shape? */
	*drive = *p;                        /* a. yes .. copy in drive  */
     else
	quit_with(1, bad_drive);            /* else .. give syntax err  */
    }

drive[0] = toupper(drive[0]);               /* uppercase search drive   */
drive_nbr = drive[0] - 'A' + 1;             /* get drive nbr from string*/

check_for= strtoul(av[1], &p, 10);	    /* get space to check for	*/

if (check_for == 0L)			    /* q. check for 0 bytes?	*/
    quit_with(0, gtzero);		    /* a. yes.. error		*/

if (*p)					    /* q. last char null?	*/
    {					    /* a. no .. check it out	*/
    switch (toupper(*p))		    /* check for nK or nM	*/
	{
	case 0:				    /* q. neither specified? 	*/
	    break;			    /* a. yes .. continue	*/

	case 'K':			    /* q. nK specified?		*/
	    check_for *= 1024L;		    /* a. yes .. multiply by 1K	*/
	    break;			    /* .. continue		*/

	case 'M':			    /* q. nM specified?		*/
	    check_for *= 1024L * 1024L;	    /* a. yes .. multiply by meg*/
	    break;			    /* .. continue		*/

	default:			    /* otherwise .. error!	*/
	    quit_with(1, bad_number);	    /* .. exit w/error		*/
	}
    }

if (_dos_getdiskfree(drive_nbr, &freespace))/* q. get freespace ok?	*/
    quit_with(0, bad_drive);		    /* a. no .. bad drive spec'd*/

avail_space =                               /* calculate the free space */
	(long) freespace.avail_clusters
	* (long) freespace.bytes_per_sector
	* (long) freespace.sectors_per_cluster;

if (avail_space < check_for)		    /* q. enough space?		*/
    {				            /* a. no .. error		*/
    p = insuf_space;		            /* .. select message	*/
    rc = 1;				    /* .. and errorlevel	*/
    }
 else                                       /* else .. space available	*/
    {
    p = enuf_space;			    /* .. ok message            */
    rc = 0;				    /* .. and errorlevel	*/
    }

printf(space_msg, p, avail_space, drive);   /* display the result	*/
return rc;				    /* .. and return to DOS	*/
}


/* ******************************************************************** *
 *      quit_with() -- give an error message, then return to DOS        *
 * ******************************************************************** */

void    quit_with(int help_flag,            /* give help message        */
		  char *msg)                /* string to print          */
{

printf(msg);                                /* give error message ..    */

if (help_flag)				    /* q. give help?		*/
   printf(help);			    /* a. yes .. print the help	*/

exit(rc);                                   /* ..and then quit          */

}


/* ******************************************************************** *
 *      control_break() -- control break intercept routine              *
 * ******************************************************************** */

int     control_break(void)
{

printf(stop_here);                          /* give error message ..    */

return(0);

}



/* ******************************************************************** *
 *      critical_handler() -- DOS critical error handler                *
 * ******************************************************************** */

#pragma argsused                    /* hold unused argument messages    */
#pragma option -O2-b-e              /* no global register allocation    */
				    /* ..or dead code elimination       */

void    interrupt critical_handler(UINT bp,
	    UINT di, UINT si, UINT ds, UINT es,
	    UINT dx, UINT cx, UINT bx, UINT ax,
	    UINT cs, UINT ip, UINT flags)
{


if (ax & 0x800)                             /* q. fail allowed?         */
   ax = (ax & 0xff00) | 3;                  /* a. yes .. fail request   */
else
   ax = (ax & 0xff00) | 2;                  /* else .. abort request    */

}
