@echo off

goto enddoc

This batch file was created by Aran Spence [CIS: 70162,3044].  Its
function is to emulate the DOS DATE command, but allow the user to set
the date using a julian date format (yyjjj) instead of mm-dd-yy.  As
Aran originally wrote it, the user-prompt was virtually identical to
that of the DATE command.  I have modified his original version, so it
now looks less like the DATE command but displays a bit more
information, and so it can operate from the command line even if the
user does not have GET.

If the user enters a julian date as a command-line parameter, JDATE
resets the date to that julian date.
             EXAMPLE:  JDATE 92005
If there is no input parameter, GET is used to prompt the user for a
date.  It is possible to use JDATE even if you don't have GET by
operating only from the command line, or by substituting some other
utility (such as STRINGS) for GET.

Note that the user must enter both of the year digits (yy),
but may enter an abbreviated set of day digits (jjj).  That is,
for julian day 92005, the user is permitted to enter 925.

One handy use for JDATE is simply to find out what the current
julian date is.

:enddoc

SET NewJD=%1
if not (%NewJD%)==() goto GotDate

:ShowDate
Fdate /Ff /Od1    /P"Current Gregorian date: "
Fdate /Ff /Oyyjjj /P"Current Julian date is: "

:GetDate
GET S "Enter new date (yyddd): " /VNewJD /L
if (%NewJD%)==() goto endit

:GotDate
Fdate /Ff /A%NewJD% /Omm-dd-yy /Iyyjjj /P"@DATE " > JUNKTEMP.BAT
if errorlevel 1 if exist JUNKTEMP.BAT del JUNKTEMP.BAT
if errorlevel 1 echo Invalid date "%NewJD%"
if errorlevel 1 goto GetDate

rem  reset the date by calling JUNKTEMP.BAT
call JUNKTEMP.BAT
del  JUNKTEMP.BAT

echo SYSTEM DATE HAS BEEN RESET
Fdate /Ff /Od1    /P"Current Gregorian date: "
Fdate /Ff /Oyyjjj /P"Current Julian date is: "

:endit
SET NewJD=
echo.
