/* ERR_RET, a program to run another program reporting
	the error return value.

	Steven A. Fischkoff, M.D.
	Last modified 9/20/89
	Placed in the public domain; may be freely used and copied.
*/

#include <process.h>
#include <stdio.h>
#include <errno.h>

extern int errno;

void main (int argc, char **argv)

	{
	int err_return;
	int map [22];
	char *err_msgs [] = {
		"The argument list was too long.\n",
		"There was an invalid argument.\n",
		"The path or file name was not found.\n",
		"There was an internal formatting error.\n",
		"There was not enough memory to run your program.\n"
	};
		map [20] = 0;
		map [19] = 1;
		map [2]  = 2;
		map [21] = 3;
		map [8]  = 4;

	if (argc < 2) {
		printf ("\nERR_RET, by Steven Fischkoff, M.D., 9/20/89.\n\n");
		printf ("ERR_RET Program_name [parameters, switches, etc.]\n");
		exit (1);
	};

	err_return = spawnvp (P_WAIT, argv [1], &argv [1]);
	if (err_return == -1) {
		printf ("\nUnsuccessful operation: ");
		printf ("%s", err_msgs [map [errno]]);
		exit (2);
	};

	printf ("\n\nProgram returned error level = %d\n", err_return & 255);
	exit (0);
	}; /* end of main */