#include <stdio.h>
#include <conio.h>

#define CR "\r\n"

char tank1[80]={""};
char tank2[80]={""};
char command[80];

void instructions(int clrflg){
char *str="" CR CR
"PURPOSE:  DUPlicate a command on the files/directories listed in FILE.LST." CR
"          This will allow you to execute one command on numerous (specific)" CR
"          files or directories." CR CR
"  USAGE:  DUP COMMAND * [arguments]" CR CR
"          The asterisk will be replaced with names in FILE.LST.  If an " CR
"          asterisk is not present the filenames will be placed at the end" CR
"          of the command line." CR CR
"EXAMPLE:  DUP DEL              ;Delete all files in FILE.LST" CR
"          DUP MD               ;Make directories from FILE.LST" CR
"          DUP RD               ;Remove directories contained in FILE.LST" CR CR
"NOTE: Pipes and redirection must be surrounded by quotes.  EXAMPLE:"CR
"          DUP echo y \"|\" del   ; remove all files from directories specified" CR
"                               ; in FILE.LST"CR
"          DUP dir * \">>\" DRS   ; ASCII text file DRS created with listing of " CR
"                               ; directory names (from FILE.LST)" CR;

	if(clrflg==0)
		clrscr();
	cprintf("%s",str);
	exit(1);
}

char *make_command(char *str){
	char *ptr;
	strcpy(command,tank1);
	strcat(command,str);
	strcat(command,tank2);
	if((ptr=strstr(command,"\n"))!=NULL)
		*ptr=' ';
	printf("\n%s\n",command);
	system(command);
}

main(int argc, char *argv[]){
	int i;
	char buffer[256];
	char *ptr;
	FILE *in;
	ptr=tank1;
	if(argc<2) instructions(0);
	for(i=1;i<argc;i++){
		if((strcmp(argv[i],"*"))==0)
			ptr=tank2;
		else {
			strcat(ptr,argv[i]);
			strcat(ptr," ");
		}
	}
	if((in=fopen("file.lst","rt"))==NULL){
		clrscr();
		printf("\nCannot find the file FILE.LST to duplicate the command \"%s * %s\"",tank1,tank2);
		instructions(1);
	}
	while((fgets(buffer,256,in))!=NULL)
		make_command(buffer);
	fclose(in);
	exit(0);
}