ECHO OFF
CLS

REM
REM This batch file is run by AFF when you press Alt-V while pointing
REM to a file.  It will allow you to run your favorite VIEW/LIST/BROWSE
REM program to view files while in the AFF program.
REM
REM FIVE patameters are passed to this batch file, in the following
REM order:
REM
REM   %1 = Full File Name (includes drive, path, and file name)
REM   %2 = Just the Drive Letter (no colon included)
REM   %3 = Path Name (this includes a backslash on the end)
REM   %4 = File Name
REM   %5 = Extension (no period)
REM
REM  NOTE:  Since a backslash is always on the end of the path name, you
REM         cannot use this name alone when using the CHDIR (CD) command.
REM         However, the fix is simple.  Just stick a period (".") on the
REM         end of the Path Name and the CD command will work fine!
REM
REM         WRONG:   CD %3
REM         RIGHT:   CD %3.
REM
REM Take the following lines out after you understand how the batch
REM file works.

CLS
ECHO Sample of what is passed to this batch file.
ECHO --------------------------------------------
ECHO   Full Name : %1
ECHO   Drive     : %2
ECHO   Path      : %3
ECHO   File Name : %4
ECHO   Extension : %5
ECHO   (correct CD command looks like this: "CD %3.")
PAUSE
CLS

REM Check the extension and perform necessary action.
REM (Everything is always capital letters.)
IF "%5" == "ZIP" GOTO ZIP
IF "%5" == "ARC" GOTO ARC
IF "%5" == "LZH" GOTO LZH
IF "%5" == "COM" GOTO HEX
IF "%5" == "EXE" GOTO HEX
IF "%5" == "GIF" GOTO GIF
GOTO TEXT

REM Run PKZIP on this ZIP file.
:ZIP
PKZIP -v %1
PAUSE
GOTO END

REM Run PKPAK on this ARC file.  You can use ARC or whatever other
REM ARCviewing utility you want.
:ARC
PKPAK -v %1
PAUSE
GOTO END

REM Run LHArc on this LHArc file.  You may also use LHARC, the older
REM version of LHArc if you want.
:LZH
LHA %1
PAUSE
GOTO END

REM I use LIST with a /H to list programs in Hex mode.  Looks better
:HEX
LIST %1 /H/M
GOTO END

REM I use VPIC to view GIF files too!
:GIF
VPIC %1
GOTO END


:TEXT
REM Put your favority FILE VIEWER Program Command HERE!
LIST %1 /M


:END
CLS
