; VAMPIRE.rs -- Robocomm script to download as many new files
; as possible from a BBS as quickly as possible.  Robo will add
; descriptions of files downloaded to the downloaded files
; directory.  NOTE: any file which currently exists in your
; configured download,upload or search directories will be
; skipped during the batch download.

TITLE "Downloads all new files w/descriptions (PCBoard)"
PARAMETER 1 "Directories to scan (blank=all)"
PARAMETER 2 "Conference Number (not name)"
ENDPARAMS

    MESSAGE "VAMPIRE -- Sucking down all new files in sight!"

    ; Make sure we are where we want to be.
    VENUE MAIN
    IF NOT EMPTY "%P2%" JOIN "%P2%"

    ; Send the command to scan and flag all new files.
    ; Only one of these two will be executed.
    IF EMPTY "%P1%" SEND "N;S;A;D;NS|"
    IF NOT EMPTY "%P1%" SEND "N;S;%P1%;D;NS|"

    ; Open a capture file for the descriptions.
    CAPTURE "VAMPIRE.LST" OVERWRITE

    ; Wait for either main board or conference command prompt
    ; to come back up.
    IF EMPTY "%P2%" WAITFOR "%BBS35%"
    IF NOT EMPTY "%P2%" WAITFOR "%BBS36%"

    ; Close the capture file
    CLOSE

    ; Request the download
    SEND "DB;Z|"

    ; See if we got anything
    WHEN "FLAGGED FILES" SEND "Y|||"
    WHEN "(1) ENTER" GOTO NOFILES
    WAITFOR "START YOUR DOWNLOAD"

    ; "Download" with no arguments uses configured protocol and sends the files
    ; to the configured download directory.  Any file that already exists in the
    ; download directory will be automatically skipped by the INTERNAL protocol
    DOWNLOAD USING "ZMODEM"

    ; Add the descriptions to the downloads database, only for those files
    ; that were successfully downloaded.
    IMPORT "D" "VAMPIRE.LST" EXISTONLY
    ERASE "VAMPIRE.LST"

    VENUE MAIN

:SUCCESS
    EXIT 0

:NOFILES
    MESSAGE "No new files to download"
    SEND "|||"
    GOTO SUCCESS
