;PCBPROMT.INC v. 2.0 - 7/11/92 10:31 PM - Copyright (c) 1992 Gregg Hommel

integer watchfor, taska, taskb
string prompt, prompt_str, log_name

;**********************************************************************
;*                                                                    *
;* First we set the various prompts that PCBoard systems use. If the  *
;* board that you are using has different prompts, or additional ones,*
;* simply initialize extra strings (S10, S11, etc.) above, and add new*
;* assign commands in this proc. The last line of the proc sets the   *
;* variable log_name to a string that includes your name and password *
;* for faster log ons.                                                *
;*                                                                    *
;**********************************************************************

proc set_prompts
   assign S0 "Command"
   assign S1 "Enter)=yes?"
   assign S2 "Enter)=no?"
   assign S3 "Password (Dots"
   assign S4 "name?" 
   assign S5 "More?"
   assign S6 "continue?"
   assign S7 "=no change?"
   assign S8 "=none?"
   assign S9 "new user?"
   strfmt log_name "%s %s^M" $USERID $PASSWORD
endproc

;**********************************************************************
;*                                                                    *
;* This procedure first grabs the current line on the terminal (the   *
;* one that contains the prompt we want to check), and then cleans it *
;* up a little so that it includes only up to the "?". It then uses   *
;* a series of if/endifs to find the "keyword" prompts that we set up *
;* in proc set_prompts. It does this via a function call to func      *
;* chk_prompt. chk_prompt uses strfind to see if the "key" string is  *
;* included in the terminal line. If so, it returns a 1 to the        *
;* if/endif, which results in a response being sent and a jump out of *
;* the string check procedures via a goto label.                      *
;*                                                                    *
;**********************************************************************

proc get_prompt
   termgets $ROW 0 prompt_str 80
   strfind prompt_str "?" I0
   I0++
   substr prompt prompt_str 0 I0
   if chk_prompt(S0)
      if chk_prompt("Qmail")
         send_cmd()
      else
         taska=1
         if taskb
            watchfor=0
         endif
      endif
      goto end_chk
   endif
   if chk_prompt(S1) || chk_prompt(S5)
      transmit "N^M"
      goto end_chk
   endif
   if chk_prompt(S2)
      if chk_prompt("graphics")
         transmit "N Q NS^M"
      else
         transmit "^M"
      endif
      goto end_chk
   endif
   if chk_prompt(S3)
      transmit $PASSWORD
      transmit "^M"
      goto end_chk
   endif
   if chk_prompt(S4)
      transmit log_name
      goto end_chk
   endif
   if chk_prompt(S6) || chk_prompt(S7) || chk_prompt(S8)
      transmit "^M"
      goto end_chk
   endif
   if chk_prompt(S9)
      transmit "r^M"
   endif
   end_chk:
endproc

func chk_prompt:integer
   strparm chk_out
   integer num=0
   if strfind prompt chk_out
      num=1
   endif
   return num
endfunc

proc holding
   watchfor=1
   while watchfor
   endwhile
endproc

