#include <stdio.h>
#include <string.h>


/* strip spaces off the end of the string */
void pascal stripspaces(char *Str) {
  char *p;

  for (p = &Str[strlen(Str)-1]; *p == ' ' && p >= Str; p--);
  p++;
  *p = 0;
}

/* convert "ABC      ZIP" to "ABC.ZIP     " */
void pascal convertfilename(char *Str) {
  char *p;

  if ((p = strchr(Str,' ')) != NULL) {
    if (p != &Str[9]) {
      *p++ = '.';
      *p++ = Str[9];
      *p++ = Str[10];
      *p++ = Str[11];
      for (; p < &Str[12]; p++)
        *p = ' ';
    }
  }
}

/* convert filename, strip spaces off the end then shift the file size, date */
/* and description to the right by one space and add the CR/LF back on       */
void pascal convert(char *Str) {
  convertfilename(Str);
  Str[77] = 0;
  stripspaces(Str);

  /* if the last digit of the SIZE is a space - then we need to shift it all */
  /* to the right by one character because everything has been shifted left  */

  if (Str[20] == ' ') {
    memmove(&Str[15],&Str[14],strlen(Str)+1);
    Str[14] = ' ';
  }

  /* if the first digit of the DATE is a space then change it to a zero */

  if (Str[23] == ' ' && Str[25] == '-')
    Str[23] = '0';

  /* if we've accidently stripped off the NEWLINE character then put it back */

  if (strchr(Str,'\n') == NULL)
    strcat(Str,"\n");
}


void main(int argc, char **argv) {
  char Str[100];
  FILE *In;
  FILE *Out;

  if (argc < 3) {
    puts("Run the program by typing the following:\n"
         "\n"
         "   MAST2PCB <infile> <outfile>\n"
         "\n"
         "where <infile> is the full name of the text file to be converted to PCBoard\n"
         "format and <outfile> is the name of the PCBoard DIR file to be created.");
    return;
  }

  if ((In = fopen(argv[1],"rt")) == NULL) {
    puts("Unable to open source file");
    return;
  }

  if ((Out = fopen(argv[2],"wt")) == NULL) {
    puts("Unable to open destination file");
    return;
  }

  while (fgets(Str,sizeof(Str),In) != NULL) {
    convert(Str);
    fputs(Str,Out);
  }

  fclose(Out);
  fclose(In);
}
