//	REPZIP.C:	A program by Lindsay McCann
//
//	REPZIP permits the use of repeated operations with PKZIP.
//	The findfirst() and findnext() functions are used to allow
//	repeated invocations of PKZIP for every filename that matches
//	a file specification provided by the REPZIP user.
//
//	USE REPZIP AT YOUR OWN RISK OR DO NOT USE IT AT ALL !
//
//
//	To compile and link using Turbo C++ 1.0:
//
//	<C:\> tcc repzip.c <Enter>
//


#include	<stdio.h>
#include	<conio.h>
#include	<dir.h>
#include	<dos.h>
#include	<process.h>

#define		PROGNAME	"PKZIP.EXE"	// Name of program to spawn.

void
get_ext( char *s, char *e)
/*	Returns extension portion of filename
	s is full filename; e points to the extension. */
{
	char *y;
	for (y = s; (*y != '.' && *y); y++);
	if(*y == '.')
		for (y++; *y; e++,y++)	*e = *y;
	*e = '\0';
	return;
}
	
void
syntax()
{
	puts("\nREPZIP by Lindsay McCann");
	puts("\n       SYNTAX: Run REPZIP exactly as you would PKZIP.");
	puts("               Instead of a single Zipfile name, you may");
	puts("               specify a wildcard filespec for example:");
	puts("\n       <C:\\TELIX\\DOWN> REPZIP -d CPP*.ZIP README.*");
	puts("\n       This will delete all files matching README.* from all");
	puts("       Zipfiles matching CPP*.ZIP.");
	puts("\n       The documentation provides further examples.");
	puts("\n");
	puts("\n");
}

#define	ABORT	0

int
ctrl_break(void)
{
	puts("\n");
	puts("User BREAK.  Terminating ...");
	return(ABORT);
}

void
chk4brk()
/*	This function does an input status check.  Break handler is called
	if Ctrl-C or Ctrl-Break pressed.	*/
{
	_AH=0x0B;
	geninterrupt(0x21);
}


/*	Pointer to list of arguments to be passed through to PKZIP. 	*/

	char	**arguments;

	char	*nullarg="  ";

void
main(int argc, char **argv)
{
	int done,i,argnum;
	struct ffblk ffblk;
	char name[25], zipname[50], ext[10];
	
	if( argc<2 || !strcmp(argv[1],"-?"))
	{
		syntax();
		exit(1);
	}

	/*	Allocate memory for the list of argument pointers	*/

	if( !(arguments = (char **)malloc( (argc+10)*sizeof(*arguments)) ) )
	{
		puts("\nOut of memory.  Terminating.");
		exit(1);
	}

	/* Set up the command line for PKZIP ... */
	
	argnum=0;
	arguments[argnum++]=nullarg;	/* Must add a null argument at front */

	/* First add switches to command line arguments */
	for( i=1; i<argc && *argv[i]=='/' || *argv[i]=='-'; i++)
		arguments[argnum++]=argv[i];

	/* Next add the address to be used to pass the Zipfile name */
	strcpy(zipname, argv[i]);
	arguments[argnum++]=name;
	if( !zipname[0] )
	{
		puts("\nREPZIP: You must specify a zipfile name (use * for all).");
		puts("\n");
		exit(1);
	}

	/* Next add the rest of the arguments passed in order. */
	while( i<argc )
		arguments[argnum++]=argv[++i];

	/* Finally, add a NULL pointer to signify end of the list. */
	arguments[argnum]=NULL;	/* Signal end of argument list */

	/* The default extension is ZIP.  User can choose another */
	get_ext(zipname, ext);
	if( !*ext )
		strcat(zipname,".ZIP");

	done=findfirst(zipname,&ffblk,0);
	name[0]='\0';
	ctrlbrk(ctrl_break);
	while (!done)
	{
		strcpy(name,ffblk.ff_name);
		spawnvp(P_WAIT, PROGNAME, arguments);
		done=findnext(&ffblk);
		chk4brk();
	}
	if( !name[0] )
	{
		puts("\nREPZIP: No zipfiles found that match: ");
		puts(zipname);
		puts("\n");
		exit(1);
	}
}