{
PROGRAM: PCBMORE.PAS
PURPOSE: TEXT FILE FORMATTER FOR PCBOARD V14.5 BY BILL SHIELDS
   DATE: 22 July 1990
}
PROGRAM SCRGEN;
uses
   dos,crt;
const
   progname = 'PCBMORE'; {allow for new scripts}
   QT = '"';
   CR = #13;
   LF = #10;
var
   infile:text;
   outfile:text;
   s1:string;
   s2:string;
   s3:string;
   parm2:string;
   parm3:string;
   counter:integer;
   numpage,tot,b:integer;
   chg_flg:boolean;
{:::::::::::::: HELP FILE GOES HERE ::::::::::::::::::}
procedure help;
   begin
      writeln(CR,LF,'PCBOARD V14.5 FILE FORMATTER   (Public Domain)',CR,LF);
      writeln ('This program will start a text file with @POFF@ and places @MORE@ every');
      writeln ('23 lines of text.',CR,LF);
      if paramstr(2) <> '/B' then
      begin
        writeln (CR,LF,'SYNTAX: PCBMORE filename [/1]',CR,LF);
        writeln ('This program expects the file to have a .TXT extension, it creates a .DAT.');
        writeln ('Extensions will not be allowed.',CR,LF);
        writeln ('The /1 switch will not allow more then 1 blank line to be inserted into ');
        writeln ('the new file.  It will strip out all other blank lines.');
      end;
      halt;
   end;
{::::::::::: CHECK TO SEE IF FILE EXIST :::::::::::::::}
function exist(str1:string):boolean;
   var
      p:pathstr;
      s:string;
      found:boolean;
   begin
      found := true;
      getdir(0,s);
      p := fsearch(str1,s);
      if p = '' then found := false;
      exist := found;
   end;

{::::: CHECK COMMAND LINE FOR EXTENSION THEN ADD IT :::::}
procedure chkparm;
begin
  chg_flg := false;
  s2 := paramstr(1);
  s3 := s2;                   {save for script name}
  if s2 = '?' then help;
    if pos('.',s2)>0 then    {if period, extension was found}
    begin
      writeln(CR,LF,'No extensions allowed, .TXT used by default');
      writeln(CR,LF,'Type ',progname,' ? to get help',CR,LF);
      halt(1);
    end;
      if paramcount > 0 then    {see if a filename was inputted}
      begin
        s1 := s2+'.dat';
        s2 := s2+'.txt';
        if not exist(s2) then   {got this far, does file exist?}
        begin
             writeln(s2,' does not exist in this directory!');
             writeln(CR,LF,'Type ',progname,' ? to get help');
              halt(1);
        end;
        assign(infile,s2);
        assign(outfile,s1);
      end else
      begin
       writeln(CR,LF,'Type ',progname,' ? to get help');
       halt;
      end;
end;

{::::: CHECK COUNTER FOR @MORE@ STATUS ::::::::::::::::::}
procedure chkit;
begin
  counter := counter+1;
  if counter > 20  then
  begin
     writeln(outfile,CR,LF,'@MORE@',CR,LF);
     counter := 0;
     numpage := numpage+1;
  end;
  writeln(outfile,s1);
end;

procedure header;
begin
    writeln(CR,LF,'PCBOARD V14.5 FILE FORMATTER  Compliments of the ISA, Ogden UT',CR,LF);
    write('CREATING ',s1,' from ',s2);
    writeln(outfile,'@POFF@',CR,LF);
end;

{:::::::::::::::: Twirler to let you know its working :::::::::::::::}
procedure twirl;
begin
  if b=0 then
     gotoxy(wherex+2,wherey);
  b:=b+1;
  tot:=tot+1;
  case b of
       2: begin gotoxy(wherex-1,wherey); write('|'); end;
       3: begin gotoxy(wherex-1,wherey); write('/'); end;
       4: begin gotoxy(wherex-1,wherey); write('-'); end;
       5: begin gotoxy(wherex-1,wherey); write('\'); end;
  else begin
         b:=1;
       end;
  end;
end;

{******************** START OF MAIN PROGRAM *******************}
  begin
    b:=0;
    tot:=1;
    numpage := 1;
    chkparm;
    reset(infile);
    rewrite(outfile);
    counter := -1;
    header;
    while not eof(infile) do
      begin
         twirl;
         readln(infile,s1);
         if (s1 = '') and (paramstr(2) = '/1') then
         begin
             chkit;
             while (s1 = '') and (not eof(infile)) do readln(infile,s1);
         end;
         chkit;
      end;
      gotoxy (wherex-2,wherey);
      writeln(' DONE!',CR,LF);
      close(outfile);
      close(infile);
      writeln('Total lines processed: ',tot,'     Number of pages: ',numpage);
end.
