<% 
' If user entered a Domain Name (second time through this form)
If request.form("DomainName") <> "" then
	
	' If user clicked on Reset button
	If Request.Form("Action") = "Reset" then
		Session("DomainName") = ""
		Session("Results") = ""	

	' Else if the user clicked on the Submit buttom
	ElseIf Request.Form("Action") = "Submit" then	

		' Store what the user entered
		Session("DomainName") = request.form("DomainName")

		' Setup ASP Error handler
		On Error Resume Next

		' Create the "ACIWhoIs" object
		Set oACI = Server.CreateObject("ACI.WhoIs")        

		' If we were able to create the object
		If IsObject( oACI ) then

			' Setup calling parameters
			HostName = "whois.internic.net"
			Query = request.form("DomainName") & vbLfCr

			' Make the WhoIs call
			Session("Results") = oACI.WhoIs( CStr(HostName), CStr(Query), CInt(30) ) 

			If Err.Number > 0 then
 				Session("Results") = "Error: " & Err.Number & " - " & Err.Description
			End If
		Else
 			Session("Results") = "Error: " & Err.Number & " - " & Err.Description
		End If

		Set oACI = Nothing
	End If
End If
%>
<html>

<head>
<title>ACI WhoIs DLL Test Page</title>
</head>

<body>

<form method="POST" action="whois.asp">
  <p><strong>Enter a domain name:</strong><br>
  <input type="text" name="DomainName" size="32" value="<% = Session("DomainName") %>"><br>
  <input type="submit" value="Submit" name="Action"> <input type="submit" value="Reset"
  name="Action"></p>
  <p><strong>Results:</strong><br>
  <textarea name="Results" rows="18" cols="72"><% = Session("Results") %></textarea></p>
</form>
</body>
</html>
