/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.led;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import sunw.demo.led.ColorsEditor;

public class CustomColor
extends Panel {
    static final int ROW = 4;
    static final int COLUMN = 4;
    static final int GAPX = 15;
    static final int GAPY = 10;
    static final int COLOR_CANVAS_WIDTH = 20;
    static final int COLOR_CANVAS_HEIGHT = 20;
    static final int BORDER = 5;
    Color[] selectedColor;
    Canvas c;
    ColorCanvas colorCanvas;
    ColorsEditor colorsEditor;
    Sb s1 = new Sb(0, 0, 0, 0, 256);
    Sb s2 = new Sb(0, 0, 0, 0, 256);
    Sb s3 = new Sb(0, 0, 0, 0, 256);

    public CustomColor(ColorsEditor colorsEditor, Color[] colorArray) {
        this.colorsEditor = colorsEditor;
        this.selectedColor = colorArray;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        SelectionPanel selectionPanel = new SelectionPanel();
        this.add((Component)selectionPanel, "South");
        this.colorCanvas = new ColorCanvas();
        this.colorCanvas.setSize(150, 140);
        this.add((Component)this.colorCanvas, "Center");
    }

    public void paint(Graphics graphics) {
    }

    void setScroll(Color color) {
        this.s1.setValue(color.getRed());
        this.s2.setValue(color.getGreen());
        this.s3.setValue(color.getBlue());
    }

    void setCanvasColor(Color color) {
        Graphics graphics = this.c.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(3, 3, this.c.getSize().width - 6, this.c.getSize().height - 6);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.c.getSize().width - 1, this.c.getSize().height - 1);
        graphics.dispose();
        this.colorsEditor.firePropertyChangeMethod();
    }

    class SelectionPanel
    extends Panel
    implements AdjustmentListener {
        public SelectionPanel() {
            CustomColor.this = CustomColor.this;
            CustomColor.this.c = new Canvas();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 3;
            CustomColor.this.c.setSize(40, 40);
            gridBagLayout.setConstraints(CustomColor.this.c, gridBagConstraints);
            this.add(CustomColor.this.c);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 1;
            Label label = new Label("R");
            label.setFont(new Font("Monospaced", 0, 13));
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(CustomColor.this.s1, gridBagConstraints);
            this.add(CustomColor.this.s1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            Label label2 = new Label("G");
            label2.setFont(new Font("Monospaced", 0, 13));
            gridBagLayout.setConstraints(label2, gridBagConstraints);
            this.add(label2);
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(CustomColor.this.s2, gridBagConstraints);
            this.add(CustomColor.this.s2);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            Label label3 = new Label("B");
            label3.setFont(new Font("Monospaced", 0, 13));
            gridBagLayout.setConstraints(label3, gridBagConstraints);
            this.add(label3);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(CustomColor.this.s3, gridBagConstraints);
            this.add(CustomColor.this.s3);
            CustomColor.this.s1.addAdjustmentListener(this);
            CustomColor.this.s2.addAdjustmentListener(this);
            CustomColor.this.s3.addAdjustmentListener(this);
        }

        public void paint(Graphics graphics) {
            CustomColor.this.s1.setSize(100, 15);
            CustomColor.this.s2.setSize(100, 15);
            CustomColor.this.s3.setSize(100, 15);
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            CustomColor.this.selectedColor[0] = new Color(CustomColor.this.s1.getValue(), CustomColor.this.s2.getValue(), CustomColor.this.s3.getValue());
            CustomColor.this.setCanvasColor(CustomColor.this.selectedColor[0]);
        }
    }

    class Sb
    extends Scrollbar {
        public Sb(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4, n5);
            CustomColor.this = CustomColor.this;
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 15);
        }
    }

    class ColorCanvas
    extends Canvas
    implements MouseListener {
        Color[] rgb = new Color[]{new Color(0, 0, 0), new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255), new Color(128, 128, 128), new Color(192, 192, 192), new Color(0, 128, 128), new Color(128, 0, 0), new Color(0, 128, 0), new Color(255, 128, 192), new Color(128, 128, 0), new Color(0, 0, 128)};
        Rectangle[] rect;
        Rectangle selectedRect;

        public ColorCanvas() {
            CustomColor.this = CustomColor.this;
            this.addMouseListener(this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = 0;
            while (n < this.rect.length) {
                if (this.rect[n].contains(point)) break;
                ++n;
            }
            if (n < this.rect.length) {
                CustomColor.this.selectedColor[0] = this.rgb[n];
                CustomColor.this.setCanvasColor(CustomColor.this.selectedColor[0]);
                CustomColor.this.setScroll(CustomColor.this.selectedColor[0]);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void paint(Graphics graphics) {
            this.rect = new Rectangle[this.rgb.length];
            this.getBackground();
            int n = 0;
            while (n < 4) {
                int n2 = 0;
                while (n2 < 4) {
                    graphics.setColor(this.getBackground());
                    graphics.draw3DRect(35 * n2 + 15, n * 30 + 10, 20, 20, false);
                    graphics.setColor(this.rgb[n * 4 + n2]);
                    graphics.fillRect(35 * n2 + 2 + 15, n * 30 + 2 + 10, 18, 18);
                    this.rect[n * 4 + n2] = new Rectangle(35 * n2 + 15, n * 30 + 10, 20, 20);
                    ++n2;
                }
                ++n;
            }
            this.selectedRect = new Rectangle(15, n * 30 + 10, 40, 40);
            CustomColor.this.setCanvasColor(CustomColor.this.selectedColor[0]);
            CustomColor.this.setScroll(CustomColor.this.selectedColor[0]);
        }
    }
}

