//-< CLASSINFO.H >---------------------------------------------------*--------*
// POST++                     Version 1.0        (c) 1998  GARRET    *     ?  *
// (Persistent Object Storage)                                       *   /\|  *
//                                                                   *  /  \  *
//                          Created:      2-Feb-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 10-Feb-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Class information maintaining
//-------------------------------------------------------------------*--------*

#ifndef __CLASSINFO_H__
#define __CLASSINFO_H__

#include "storage.h"

class object;

class class_descriptor { 
    friend class storage;
  protected:
    enum { class_hash_table_size = 117 };
    static class_descriptor* hash_table[class_hash_table_size];
    static int count;
    class_descriptor* collision_chain;
    static class_descriptor* list;
    class_descriptor* next;

    void (*constructor)(object*);
    
  public:
    const char*  name;
    const int    id;
    const size_t size; // size of fixed part of the class

    static class_descriptor* find_class(char const* class_name);

    class_descriptor(const char* name, size_t size, void (*cons)(object*));
};

#define REF(x) \
   if (gc_stack) { gc_stack[sp].ptr=(object**)&x; gc_stack[sp].len=1; sp+=1; }\
   else if (x != NULL) { *(char**)&x += shift; }
	         
#define REFS(x) \
   if (gc_stack) { \
       gc_stack[sp].ptr = (object**)x; gc_stack[sp].len = items(x); sp += 1; \
   } else { size_t len = items(x); char** p = (char**)x; \
       do { if (*p != NULL) { *p += shift; } p += 1; } while (--len != 0); \
   }

#define VREFS(x) { \
   size_t len = \
       (object**)((char*)this+((object_header*)this-1)->size) - (object**)x; \
   if (gc_stack) { \
       gc_stack[sp].ptr = (object**)x; gc_stack[sp].len = len; sp += 1; \
   } else { \
       char** p = (char**)x; \
       do { if (*p != NULL) { *p += shift; } p += 1; } while (--len != 0); \
   } \
}

#define NO_REFS  ;

#define CLASSINFO(NAME, FIELD_LIST) \
    NAME() { \
	int sp = 0; \
	gc_segment* const gc_stack = storage::gc_stack; \
	long const shift = storage::base_address_shift; \
	if (gc_stack != NULL) { FIELD_LIST storage::gc_stack=&gc_stack[sp]; } \
	else if (shift != 0) { FIELD_LIST } \
    } \
    static void constructor(object* ptr); \
    static class_descriptor self_class

#define REGISTER(NAME) \
    void NAME::constructor(object* ptr) { new (ptr) NAME; } \
    class_descriptor NAME::self_class(#NAME, sizeof(NAME), &NAME::constructor)

#endif
