//-< OBJECT.H >------------------------------------------------------*--------*
// POST++                     Version 1.0        (c) 1998  GARRET    *     ?  *
// (Persistent Object Storage)                                       *   /\|  *
//                                                                   *  /  \  *
//                          Created:      2-Feb-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  2-Feb-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Main header file. Persistent object interface.
//-------------------------------------------------------------------*--------*

#ifndef __OBJECT_H__
#define __OBJECT_H__

#include "classinfo.h"

#define new_in(STORAGE, CLASS) new (CLASS::self_class, STORAGE) CLASS 

class object { 
  public:
    size_t get_size() const { 
	return storage::find_storage(this)->get_header(this)->size; 
    }
    class_descriptor* get_classinfo() const {     
	storage* sp = storage::find_storage(this);
	return sp->get_object_class(sp->get_header(this)->cid);
    }
    storage* get_storage() const { 
	return storage::find_storage(this);
    }

    void* operator new(size_t size, class_descriptor& desc, storage& sp, 
		       size_t varying_size = 0) 
    { 
	void* p = sp.allocate(desc.id, size + varying_size);
	memset(p, 0, size + varying_size);
	return p;
    }

    void* operator new(size_t, object* ptr) { return ptr; } 
    
    void operator delete(void* p) {
	object* obj = (object*)p;
	storage* sp = storage::find_storage(obj);
	sp->free(sp->get_header(obj));
    }
};

#endif


