unit FrProper;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, UserMan, NTCommon;

type
  TFrmProperty = class(TForm)
    edtUserName: TEdit;
    Label1: TLabel;
    edtDomain: TEdit;
    Label2: TLabel;
    edtFullName: TEdit;
    Label3: TLabel;
    edtComment: TEdit;
    Label4: TLabel;
    Bevel1: TBevel;
    edtPassword: TEdit;
    Label5: TLabel;
    edtConfirm: TEdit;
    Label6: TLabel;
    Bevel2: TBevel;
    cbxScript: TCheckBox;
    cbxAccountDisabled: TCheckBox;
    cbxHomDirReq: TCheckBox;
    cbxLocked: TCheckBox;
    cbxPasswordNotReq: TCheckBox;
    cbxCannotChange: TCheckBox;
    cbxNeverExpired: TCheckBox;
    Bevel3: TBevel;
    edtLogonCount: TEdit;
    Label7: TLabel;
    edtBadCount: TEdit;
    Label8: TLabel;
    edtLastLogon: TEdit;
    Label9: TLabel;
    edtLastLogoff: TEdit;
    Label10: TLabel;
    edtHomeDir: TEdit;
    edtWorkstations: TEdit;
    Label11: TLabel;
    Label12: TLabel;
    btnOk: TButton;
    btnCancel: TButton;
    lbxMemberOf: TListBox;
    lbxNotMemberOf: TListBox;
    btnToRight: TButton;
    btnToLeft: TButton;
    Label13: TLabel;
    Label14: TLabel;
    rgrLoc_Glob: TRadioGroup;
    procedure btnOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnToRightClick(Sender: TObject);
    procedure btnToLeftClick(Sender: TObject);
    procedure lbxNotMemberOfClick(Sender: TObject);
    procedure OnControlChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure MoveItems(LBXSource, LBXDest: TListBox);
  end;

var
  FrmProperty: TFrmProperty;

implementation

{$R *.DFM}

Uses FrmMan;

procedure TFrmProperty.btnOkClick(Sender: TObject);
var
  Opt: TUserFlags;
begin
  if ((EdtPassword.Tag > 0) or (EdtConfirm.Tag > 0)) and
     (EdtPassword.Text <> EdtConfirm.Text) then
       begin ShowMessage('Password and confirmation do not match !'); Exit; end;

  with FrmManager.UserMan do
    begin
    UserInfo.FullName := EdtFullName.Text;
    UserInfo.Comment  := EdtComment.Text;
    UserInfo.Password := EdtPassword.Text;
    Opt := [];
    if  cbxScript.Checked then Opt := Opt + [F_SCRIPT];
    if  cbxAccountDisabled.Checked then Opt := Opt + [F_ACCOUNTDISABLE];
    if  cbxHomDirReq.Checked then Opt := Opt + [F_HOMEDIR_REQUIRED];
    if  cbxLocked.Checked then Opt := Opt + [F_LOCKOUT];
    if  cbxPasswordNotReq.Checked then Opt := Opt + [F_PASSWD_NOTREQD];
    if  cbxCannotChange.Checked then Opt := Opt + [F_PASSWD_CANT_CHANGE];
    if  cbxNeverExpired.Checked then Opt := Opt + [F_DONT_EXPIRE_PASSWD];
    UserInfo.Options := Opt;
    UserInfo.HomeDir := edtHomeDir.Text;
    UserInfo.Workstations := edtWorkstations.Text;
    if FrmManager.rbLocal.Checked then
      begin
      MemberOfLocal := lbxMemberOf.Items;
      end else
      begin
      MemberOfGlob := lbxMemberOf.Items;
      end;
    end;
  ModalResult := mrOk;
end;



procedure TFrmProperty.FormCreate(Sender: TObject);
var
  i: integer;
begin
  with FrmManager.UserMan do
    begin
    EdtUserName.Text  := UserName;
    EdtDomain.Text    := UserInfo.Domain;
    EdtFullName.Text  := UserInfo.FullName;
    EdtComment.Text   := UserInfo.Comment;
    EdtPassword.Text  := '********';
    EdtConfirm.Text   := '********';
    cbxScript.Checked          := F_SCRIPT in UserInfo.Options;
    cbxAccountDisabled.Checked := F_ACCOUNTDISABLE in UserInfo.Options;
    cbxHomDirReq.Checked       := F_HOMEDIR_REQUIRED in UserInfo.Options;
    cbxLocked.Checked          := F_LOCKOUT in UserInfo.Options;
    cbxPasswordNotReq.Checked     := F_PASSWD_NOTREQD in UserInfo.Options;
    cbxCannotChange.Checked    := F_PASSWD_CANT_CHANGE in UserInfo.Options;
    cbxNeverExpired.Checked    := F_DONT_EXPIRE_PASSWD in UserInfo.Options;
    edtLogonCount.Text := IntToStr(UserInfo.LogonCount);
    edtBadCount.Text   := IntToStr(UserInfo.BadPasswordCount);
    if UserInfo.LastLogon = cnst1970 then edtLastLogon.Text := 'never'
      else edtLastLogon.Text  := DateTimeToStr(UserInfo.LastLogon);
    if UserInfo.LastLogOff = cnst1970 then edtLastLogOff.Text := 'never'
      else edtLastLogOff.Text  := DateTimeToStr(UserInfo.LastLogoff);
    edtHomeDir.Text      := UserInfo.HomeDir;
    edtWorkstations.Text := UserInfo.Workstations;
    if FrmManager.rbLocal.Checked then
      begin
      rgrLoc_Glob.ItemIndex := 0;
      lbxMemberOf.Items.Assign(MemberOfLocal);
      lbxNotMemberOf.Items.Assign(LocalGroups);
      end else
      begin
      rgrLoc_Glob.ItemIndex := 1;
      lbxMemberOf.Items.Assign(MemberOfGlob);
      lbxNotMemberOf.Items.Assign(GlobalGroups);
      end;
    end;
  for i := 0 to lbxMemberOf.Items.Count - 1 do
    if lbxNotMemberOf.Items.IndexOf(lbxMemberOf.Items[i]) <> -1 then
      lbxNotMemberOf.Items.Delete(lbxNotMemberOf.Items.IndexOf(lbxMemberOf.Items[i]));
end;

procedure TFrmProperty.MoveItems(LBXSource, LBXDest: TListBox);
var
  i, index: integer;
begin
  for i := 0 to LBXSource.Items.Count - 1 do
    if LBXSource.Selected[i] then
      begin
      LBXDest.Items.AddObject(LBXSource.Items[i],LBXSource.Items.Objects[i]);
      end;
  for i := 0 to LBXDest.Items.Count - 1 do
    begin
    index := LBXSource.Items.IndexOf(LBXDest.Items[i]);
    if index <> -1 then LBXSource.Items.Delete(index);
    end;
  lbxNotMemberOfClick(nil);
end;


procedure TFrmProperty.btnToRightClick(Sender: TObject);
begin
  MoveItems(LBXMemberOf, LBXNotMemberOf);
end;

procedure TFrmProperty.btnToLeftClick(Sender: TObject);
begin
  MoveItems(LBXNotMemberOf, LBXMemberOf);
end;

procedure TFrmProperty.lbxNotMemberOfClick(Sender: TObject);
begin
  BtnToRight.Enabled :=  LBXMemberOf.SelCount > 0;
  BtnToLeft.Enabled :=  LBXNotMemberOf.SelCount > 0;
end;

procedure TFrmProperty.OnControlChange(Sender: TObject);
begin
  (Sender as TComponent).Tag := 1;
end;

end.
