unit FrGroup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFrmGroups = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    memMembers: TMemo;
    Label1: TLabel;
    EdtDescription: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmGroups: TFrmGroups;

implementation

{$R *.DFM}
  Uses FrmMan;


procedure TFrmGroups.FormCreate(Sender: TObject);
begin
  with FrmManager do
    begin
    Self.Caption := Self.Caption + ' '+ lbxGroups.Items[lbxGroups.ItemIndex];
    if rbLocal.Checked then
      begin
      memMembers.Lines.Assign(UserMan.LocalGroupMembers);
      edtDescription.Text := UserMan.LocalGroupComment;
      end;
    if rbGlobal.Checked then
      begin
      memMembers.Lines.Assign(UserMan.GlobalGroupMembers);
      edtDescription.Text := UserMan.GlobalGroupComment;
      end;
    end;
end;

procedure TFrmGroups.btnOKClick(Sender: TObject);
begin
  with FrmManager do
    begin
    if rbLocal.Checked then
      begin
      UserMan.LocalGroupComment := edtDescription.Text;
      UserMan.LocalGroupMembers := memMembers.Lines;
      end;
    if rbGlobal.Checked then
      begin
      UserMan.GlobalGroupComment := edtDescription.Text;
      UserMan.GlobalGroupMembers := memMembers.Lines;
      end;
    end;
end;

end.
