unit FrmNewSc;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TFrmNewSevice = class(TForm)
    EdtServiceName: TEdit;
    EdtDisplayName: TEdit;
    EdtFileName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    btnCreate: TButton;
    btnCancel: TButton;
    spbBrowse: TSpeedButton;
    rgbStartType: TRadioGroup;
    procedure spbBrowseClick(Sender: TObject);
    procedure EdtServiceNameChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmNewSevice: TFrmNewSevice;

implementation

{$R *.DFM}

procedure TFrmNewSevice.spbBrowseClick(Sender: TObject);
begin
  with TOpenDialog.Create(nil) do
    try
    FileName := edtFileName.Text;
    DefaultExt := '*.exe';
    Filter := 'Executable files (*.exe)|*.exe|All files (*.*)|*.*|';
    if Execute then edtFileName.Text := FileName;
    finally
    Free;
    end;
end;

procedure TFrmNewSevice.EdtServiceNameChange(Sender: TObject);
begin
  btnCreate.Enabled := (Trim(edtFileName.Text) <> '') and
                       (Trim(edtDisplayName.Text) <> '') and
                       (Trim(edtServiceName.Text) <> '');
end;

end.
