unit FrFileS;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, FilSecur, ComCtrls, NTCommon, ShellAPI, Grids, Outline,
  DirOutln, StdCtrls, FileCtrl;

type
  TFrmFileSecurity = class(TForm)
    pnlFiles: TPanel;
    lvDisk: TListView;
    imImages: TImageList;
    pnlDir: TPanel;
    Splitter1: TSplitter;
    dlbDirTree: TDirectoryListBox;
    pnlDrivers: TPanel;
    dcbDrivers: TDriveComboBox;
    FileSecurity1: TFileSecurity;
    procedure FormCreate(Sender: TObject);
    procedure dlbDirTreeChange(Sender: TObject);
    procedure lvDiskCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure Splitter1Moved(Sender: TObject);
    procedure lvDiskDblClick(Sender: TObject);
  private
    { Private declarations }
    CurrentDir: string;
  public
    { Public declarations }
    procedure InitializeList;
  end;

var
  FrmFileSecurity: TFrmFileSecurity;


implementation

{$R *.DFM}
Uses
  FrProp;

procedure TFrmFileSecurity.FormCreate(Sender: TObject);
begin
  Splitter1Moved(nil);
  CurrentDir := GetCurrentDir+'\';
  InitializeList;
end;

procedure TFrmFileSecurity.InitializeList;
var
  SearchRec: TSearchRec;
  Found: DWORD;
  Icon: TIcon;
  IconIndex: WORD;
  S: string;
  Dir: array[0..511] of char;
begin
  lvDisk.Items.Clear;
//  lvDisk.IconOptions.AutoArrange := false;
  imImages.Clear;
  FillChar(SearchRec, SizeOf(SearchRec), 0);
  Found := FindFirst(CurrentDir+'*.*', faAnyFile, SearchRec);
  while Found = 0 do
  begin
  if (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
    begin
    S := CurrentDir+SearchRec.Name;
    StrCopy(Dir, PChar(S));
    icon := TIcon.Create;
    icon.Handle := ExtractAssociatedIcon(hInstance, Dir, IconIndex);
    icon.Transparent := true;
    imImages.AddIcon(icon);
     with lvDisk.Items.Add do
       begin
       ImageIndex := imImages.Count-1;
       Caption := SearchRec.Name;
       Data := Pointer(SearchRec.Attr);
       end;
    end;
  Found := FindNext(SearchRec);
  end;
  FindClose(SearchRec);
  FileSecurity1.FileName := CurrentDir;
  Caption := 'File security: '+CurrentDir + '     ('+FileSecurity1.FileSystem+')';
//  lvDisk.IconOptions.AutoArrange := true;
end;

procedure TFrmFileSecurity.dlbDirTreeChange(Sender: TObject);
begin
  CurrentDir := dlbDirTree.Directory;
  if CurrentDir[Length(CurrentDir)] <> '\' then CurrentDir := CurrentDir + '\';
  InitializeList;
end;

procedure TFrmFileSecurity.lvDiskCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
var
  value1, Value2: integer;
begin
  value1 := Integer(Item1.Data) and (not faArchive);
  value2 := Integer(Item2.Data) and (not faArchive);
  if Value1 > Value2 then Compare := -1 else
  if Value2 > Value1 then Compare := 1 else
   Compare := 0;
end;

procedure TFrmFileSecurity.Splitter1Moved(Sender: TObject);
begin
  dcbDrivers.Width := pnlDrivers.Width - 8;
end;

procedure TFrmFileSecurity.lvDiskDblClick(Sender: TObject);
begin
  if lvDisk.ItemFocused = nil then Exit;
  Filesecurity1.FileName := CurrentDir + lvDisk.ItemFocused.Caption;
  with TFrmSecProperty.Create(nil) do
    try
    ShowModal;
    finally
    Release;
    end;
end;

end.
