/****************************************************************************

    CLASS:    GGstring

    PURPOSE:  A string class. This function, inhierited from the GGcharMem
              class, works on any type of string. Although most functions
              work with a NULL terminated string, this string class is not
              NULL terminated, but size terminated. To function properly with
              those functions that need a NULL terminated string, just call
              'AddVNull()' and a virtual NULL will be added. I say virtual
              because if it was a physical NULL, that would increase the
              length of the string. 'AddVNull()' puts a NULL at the end, but
              doesn't increase the size of the string.

              Some of the functions this class can do is:

              insert, delete, replace, remove, find, compare, trim and assign.

              Take a moment to look at the many functions and overloaded
              operators that this class has.

              This class is similar with the MFC CString class from Microsoft,
              yet this class works on the SunOS as well, not just on Windows.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGstring_
#define _GGstring_

// For GGstring.Find()
#define _NOT_FOUND_ -3

typedef struct {

union {
char ch[2];
short siUnicode;
};
} _UNI_CODE_DEF_;

class GGstring;

class GGstring : public GGcharMem {

private:

  GGstring *pTmp;
  GGintMem cTmpInt;
  char *pFormatBuffer;
  va_list vMarker;
  int iErrTmp;
  _UNI_CODE_DEF_ sValues;

//-----------------------------------
public:
//-----------------------------------
  GGstring(void);
//-----------------------------------
  ~GGstring(void);
//-----------------------------------
  GGstring &operator=(GGuniCode &sUniCode);
//-----------------------------------
  GGstring &operator=(GGstring &sString);
//-----------------------------------
  GGstring &operator=(char *pValue);
//-----------------------------------
  void AddVNull(void);
//-----------------------------------
  int IsTmpError(void);
//-----------------------------------
  long Long(void);
//-----------------------------------
  short Short(void);
//-----------------------------------
  int Int(void);
//-----------------------------------
  int Len(void);
//-----------------------------------
  void Upper(void);
//-----------------------------------
  void Lower(void);
//-----------------------------------
  int ReplaceChar(char cFrom, char cTo);
//-----------------------------------
  int RemoveChar(char ch);
//-----------------------------------
  int RemoveChar(char *pChars);
//-----------------------------------
  int Trim(char cTrim = ' ');
//-----------------------------------
  int Find(char *pFindString, int iStartPos = 0);
//-----------------------------------
  int Find(char cFind, int iStartPos = 0);
//-----------------------------------
  GGintMem &FindEx(char cFind, int iStartPos = 0, int iMaxFinds = 0);
//-----------------------------------
  GGintMem &FindEx(char *pFindString, int iStartPos = 0, int iMaxFinds = 0);
//-----------------------------------
  int Insert(int iStartPos, char *pString);
//-----------------------------------
  int Insert(int iStartPos, GGstring &sString);
//-----------------------------------
  int CopyFrom(char *pBuffer, int iBufferLen);
//-----------------------------------
  int CopyTo(char *pBuffer, int iBufferLen);
//-----------------------------------
  int FormatBuffer(char *pFormat, ...);
//-----------------------------------
  GGstring &operator*(short sNum);
//-----------------------------------
  GGstring &operator*(int iNum);
//-----------------------------------
  GGstring &operator*(long lNum);
//-----------------------------------
  GGstring &operator/(short sNum);
//-----------------------------------
  GGstring &operator/(int iNum);
//-----------------------------------
  GGstring &operator/(long lNum);
//-----------------------------------
  GGstring &operator-(short sNum);
//-----------------------------------
  GGstring &operator-(int iNum);
//-----------------------------------
  GGstring &operator-(long lNum);
//-----------------------------------
  GGstring &operator+(short sNum);
//-----------------------------------
  GGstring &operator+(int iNum);
//-----------------------------------
  GGstring &operator+(long lNum);
//-----------------------------------
  GGstring &operator<<(char *pValue);
//-----------------------------------
  GGstring &operator<<(GGuniCode &sUniCode);
//-----------------------------------
  GGstring &operator<<(GGstring &sString);
//-----------------------------------
  GGstring &operator<<(char ch);
//-----------------------------------
  GGstring &operator<<(int iNum);
//-----------------------------------
  GGstring &operator<<(short iNum);
//-----------------------------------
  GGstring &operator<<(long lNum);
//-----------------------------------
  int operator==(GGstring &sCompare);
//-----------------------------------
  int operator>(GGstring &sCompare);
//-----------------------------------
  int operator<(GGstring &sCompare);
//-----------------------------------
  int operator==(char *pCompare);
//-----------------------------------
  int operator>(char *pCompare);
//-----------------------------------
  int operator<(char *pCompare);
//-----------------------------------
// GBG. On the SunOS, the C++ compiler doesn't like
// predefined values on operators. So I'm taking it
// out.
//  GGstring &operator()(int iStart, int iEnd = 0);
  GGstring &operator()(int iStart, int iEnd);
//-----------------------------------
// These two overrides are for streams
//-----------------------------------
#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  friend ostream &operator<<(ostream &stream, GGstring &sStr)
  {
    int iLen, x;

    iLen = sStr.Len();

    x = 0;

    if(iLen)
    {
      while(x < iLen-1)
      {
        stream.write(&sStr[x], sStr.SizeOf());
        x++;
   
      }

      return( stream.write(&sStr[x], sStr.SizeOf()) );
    }
    else
    {
      return( stream );
    }

  }
//-----------------------------------
  friend istream &operator>>(istream &stream, GGstring &sStr)
  {
    int iLen;

    iLen = 2048;
    sStr.ReDimArray(iLen);
    iLen = 1;

    do
    {
      stream.read(&sStr[iLen-1], sStr.SizeOf());

      if('\n' == sStr[iLen-1])
      {
        break;
      }
      iLen++;
      sStr.ReDimArray(iLen);
    }
    while(0 != stream.gcount());

    sStr.ReDimArray(iLen-1);

    return(stream);

  }
#endif
};

#endif
