/****************************************************************************

    CLASS:    GGmemory

    PURPOSE:  This is the base class for all array types. This class does
              the allocating for all array type classes.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGmemory_
#define _GGmemory_

class GGmemory {

private:

  GGmemory *pTmpMem;
  int iPageArraySize;
  int iTotalSize;
  int iPhysicalSize;
  int iError;
  int iYou, iMe;
  
public:
  void *pMemory;
  int iLastIndex;
  unsigned char ucGarbage;

//-----------------------------------
  virtual int SizeOf(void) = 0;
//-----------------------------------
  GGmemory &operator=(GGmemory &sMemory);
//-----------------------------------
  int GetArraySize(void);
//-----------------------------------
  int IsDimmed(void);
//-----------------------------------
  int ReDimArray(int iNewSize);
//-----------------------------------
  void MemSet(char cChar = 0);
//-----------------------------------
  unsigned LastIndex(void);
//-----------------------------------
  int IsOutOfBounds(void);
//-----------------------------------
  void *GetMemory(void);
//-----------------------------------
  ~GGmemory();
//-----------------------------------
  GGmemory(int iPageSize = 0);
//-----------------------------------
  int GetByteCount(void);
//-----------------------------------
  int GetPageArrayCount(void);
//-----------------------------------
};

#endif
