/****************************************************************************

    CLASS:    GGlinkList

    PURPOSE:  A class for creating a link list

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGlinkList_
#define _GGlinkList_

//******************************************
typedef struct LinkList {
  char *pnt;
  int iID;
  int iLen;
  struct LinkList *prev;
  struct LinkList *next;
} PointerList;

//******************************************
class GGlinkList {

private:
  PointerList *firstPointer;
  PointerList *listPointer;
  int iTotalItems;
  int iIDCnt;
  char cName[128];
#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  GGlock *pLock;
#endif

public:
//--------------------------
// Unlock the list after adding or
// deleting.
//
  void UnLock(void);
//--------------------------
// Lock the list before adding or
// deleting.
//
  void Lock(void);
//--------------------------
// There is a lock associated with this
// link list.
//
  int HasLock(void);
//--------------------------
// Empty this link list
//
  void Clear(void);
//--------------------------
// Create a link list with a name.
//
  GGlinkList(char *pName);
//--------------------------
// Add anything of size 'iPointerLen'.
//
  int Add(void *pnt, int iPointerLen);
//--------------------------
// Delete an item at 'iPos'.
// Call Lock() and UnLock().
//
  int Delete(int iPos);
//--------------------------
// Number of items in this link list.
//
  int NumItems();
//--------------------------
// GBG This function doesn't call Lock() and
// UnLock() inside.
// Reason is because of 'for loops' and also
// 'while loops'. Call Lock() before the 'loops'
// and UnLock() after the 'loops'.
// Remember, you want to loop thru a full list,
// because some thread might come in and delete or
// add to the list if you where doing a Get() in
// a loop with the Lock functions inside of Get().
//
  void *Get(int iPos);
//--------------------------
// Get length of pointer stored at 'iPos'
// Returns -1 on error
//
  int GetLen(int iPos);
//--------------------------
// Get length of pointer stored by 'iID'
// Returns -1 on error
//
  int GetLenByID(int iID);
//--------------------------
// Get an id number associated with 'iPos'.
//
  int GetID(int iPos);
//--------------------------
// Delete an item by it's id number.
// Call Lock() and UnLock().
//
  int DeleteByID(int iID);
//--------------------------
// Find an item by it's id number.
//
  void *FindByID(int iID);
//--------------------------
  ~GGlinkList();
//--------------------------
};
#endif
